/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger.registry;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DbSettings
implements Serializable {
    private static Logger debugLogger = Logger.getLogger((String)DbSettings.class.getName());
    private static final long serialVersionUID = -5558302310192532495L;
    private String JDBCdriver;
    private String connectionString;
    private String userName;
    private String password;
    private int maxInsertStringSize;

    public DbSettings() {
        this.initFromProperties();
    }

    private void initFromProperties() {
        Properties properties = new Properties();
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
            properties.load(new FileInputStream("config/sqlsetup.properties"));
            this.JDBCdriver = properties.getProperty("de.uka.ipd.sdq.logger.sql.JDBCdriver");
            this.connectionString = properties.getProperty("de.uka.ipd.sdq.logger.sql.ConnectionString");
            this.userName = properties.getProperty("de.uka.ipd.sdq.logger.sql.UserName");
            this.password = properties.getProperty("de.uka.ipd.sdq.logger.sql.Password");
            this.maxInsertStringSize = Integer.parseInt(properties.getProperty("de.uka.ipd.sdq.logger.sql.MaxInsertStringSize"));
        }
        catch (IOException e) {
            debugLogger.error((Object)"Could not read sqlsetup.properties.", (Throwable)e);
        }
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setJDBCdriver(String jDBCdriver) {
        this.JDBCdriver = jDBCdriver;
    }

    public String getJDBCdriver() {
        return this.JDBCdriver;
    }

    public int getMaxInsertStringSize() {
        return this.maxInsertStringSize;
    }
}

