/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger.db;

import de.uka.ipd.sdq.logger.db.DatabaseConnectionFactory;
import de.uka.ipd.sdq.logger.registry.DbSettings;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DatabaseWriterThread
extends Thread
implements Runnable {
    private Connection databaseConnection;
    private DbSettings dbSettings;
    private String sqlExpressionToExecute;
    private final int maxErrorOutputSize = 1100;
    private static Logger debugLogger = Logger.getLogger((String)DatabaseWriterThread.class.getName());

    public DatabaseWriterThread(DbSettings dbSettings) {
        this.dbSettings = dbSettings;
    }

    private void executeQuery(String sqlExpression) throws SQLException {
        block7: {
            this.setUpDbConnection();
            if (this.databaseConnection != null) {
                Statement st = this.databaseConnection.createStatement();
                try {
                    try {
                        int i = st.executeUpdate(sqlExpression);
                        debugLogger.info((Object)"query sent");
                        debugLogger.debug((Object)("query (size " + sqlExpression.length() + "): " + sqlExpression));
                        if (i == -1) {
                            debugLogger.error((Object)("DB error. Executed Statement returned -1. Query (except) ws: " + this.trimSqlExpression(sqlExpression)));
                        }
                        st.close();
                        break block7;
                    }
                    catch (SQLException e) {
                        debugLogger.error((Object)("SQL query execution error; query (excerpt) was: " + this.trimSqlExpression(sqlExpression)));
                        throw e;
                    }
                }
                finally {
                    this.databaseConnection.close();
                    this.databaseConnection = null;
                }
            }
            debugLogger.fatal((Object)"Finally, no SQL connection. Check for connection settings in LogServer and check for running instance of SQL Server");
        }
    }

    private String trimSqlExpression(String sqlExpression) {
        String returnExpr = sqlExpression.length() > 1100 ? String.valueOf(sqlExpression.substring(0, 733)) + " [..] " + sqlExpression.substring(sqlExpression.length() - 366, sqlExpression.length()) : sqlExpression;
        return returnExpr;
    }

    private void setUpDbConnection() {
        if (this.databaseConnection == null) {
            try {
                this.databaseConnection = DatabaseConnectionFactory.createNewDbConnection(this.dbSettings);
            }
            catch (SQLException e) {
                debugLogger.fatal((Object)("Could not establish DB connection. " + e));
            }
        }
    }

    public void setSqlExpressionToExecute(String sqlExpressionToExecute) {
        this.sqlExpressionToExecute = sqlExpressionToExecute;
    }

    @Override
    public void run() {
        try {
            if (this.sqlExpressionToExecute == null) {
                debugLogger.error((Object)"Error: Call setSqlExpressionToExecute before running the thread.");
            } else {
                this.executeQuery(this.sqlExpressionToExecute);
                this.sqlExpressionToExecute = null;
            }
        }
        catch (SQLException e) {
            debugLogger.fatal((Object)("Error: Database write failed. " + e));
        }
    }
}

