/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger.db;

import de.uka.ipd.sdq.logger.ILogEntry;
import de.uka.ipd.sdq.logger.db.AsynchronousCacheFlusher;
import de.uka.ipd.sdq.logger.db.DatabaseWriterThread;
import de.uka.ipd.sdq.logger.enums.ILogEntryItemTypeDatatypeGetter;
import de.uka.ipd.sdq.logger.enums.LogEntryItemType;
import de.uka.ipd.sdq.logger.enums.LogEntryItemTypeDatatypesSql;
import de.uka.ipd.sdq.logger.registry.DbSettings;
import de.uka.ipd.sdq.logger.stringformatters.ObjectToStringFormatter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class DatabaseWriter {
    private int cacheCapacity;
    private int cacheCapacityMax;
    private List<ILogEntry> logEntries;
    private int entryCount;
    private AtomicBoolean areTablesSetUp;
    private ILogEntryItemTypeDatatypeGetter typeGetter;
    private ObjectToStringFormatter stringFormatter;
    private DatabaseWriterThread dbWriteThread;
    private StringBuilder cachedSqlExpressions;
    private AtomicBoolean isCachedInsertExpressionInitialised;
    private ExecutorService executorService;
    private static Logger debugLogger = Logger.getLogger((String)DatabaseWriter.class.getName());

    public DatabaseWriter(DbSettings dbSettings) {
        this.cacheCapacity = dbSettings.getMaxInsertStringSize();
        this.cacheCapacityMax = this.cacheCapacity + 2000;
        this.entryCount = 0;
        this.areTablesSetUp = new AtomicBoolean(false);
        this.typeGetter = new LogEntryItemTypeDatatypesSql();
        this.stringFormatter = new ObjectToStringFormatter();
        this.cachedSqlExpressions = new StringBuilder(this.cacheCapacityMax);
        this.isCachedInsertExpressionInitialised = new AtomicBoolean(false);
        this.dbWriteThread = new DatabaseWriterThread(dbSettings);
        this.executorService = Executors.newSingleThreadExecutor();
        new AsynchronousCacheFlusher(this, 5).start();
    }

    public void initDatabase() {
        try {
            this.initTables();
        }
        catch (SQLException e) {
            debugLogger.error((Object)("Could not initialize DB." + e + e.getMessage()), (Throwable)e);
        }
    }

    public void writeLogEntriesToDatabase(List<ILogEntry> logEntries) {
        this.logEntries = logEntries;
        try {
            this.initTables();
            for (ILogEntry logEntry : this.logEntries) {
                this.appendInsertToCache(logEntry);
            }
        }
        catch (SQLException e) {
            debugLogger.error((Object)"Error when writing log entries to database. ", (Throwable)e);
        }
    }

    public void writeLogEntryToDatabase(ILogEntry logEntry) {
        try {
            this.initTables();
            this.appendInsertToCache(logEntry);
        }
        catch (SQLException e) {
            debugLogger.error((Object)"Error when writing log entry to database. ", (Throwable)e);
        }
    }

    public void dropEntriesTable() {
        try {
            this.executeQuery("DROP TABLE IF EXISTS logEntries; ");
            debugLogger.info((Object)"Dropped table logEntries");
        }
        catch (SQLException e) {
            debugLogger.error((Object)"Could not drop table. ", (Throwable)e);
        }
    }

    public void loadEntriesTableFromFile(File file) {
        try {
            StringBuffer fileData = new StringBuffer();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                fileData.append(buf, 0, numRead);
            }
            reader.close();
            this.executeQuery(fileData.toString());
            debugLogger.info((Object)"Loaded SQL file");
        }
        catch (SQLException e) {
            debugLogger.error((Object)"Failed to load SQL file (SQL error). ", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            debugLogger.error((Object)"Failed to load SQL file (file not found). ", (Throwable)e);
        }
        catch (IOException e) {
            debugLogger.error((Object)"Failed to load SQL file (IO Error). ", (Throwable)e);
        }
    }

    public synchronized void flushCachedExpressions() throws SQLException {
        if (this.cachedSqlExpressions != null && this.cachedSqlExpressions.length() != 0) {
            String fixedInsertStatement = this.cachedSqlExpressions.toString().substring(0, this.cachedSqlExpressions.toString().length() - 2);
            this.executeQuery(fixedInsertStatement);
            this.cachedSqlExpressions = new StringBuilder(this.cacheCapacityMax);
            this.isCachedInsertExpressionInitialised.set(false);
            debugLogger.info((Object)"DatabaseWriter cache flushed");
        }
    }

    private void initTables() throws SQLException {
        if (this.areTablesSetUp.compareAndSet(false, true)) {
            debugLogger.debug((Object)"Setting up DB Tables...");
            this.executeQuery(this.createSetUpTablesString());
        }
    }

    private synchronized void executeQuery(String sqlExpression) throws SQLException {
        if (sqlExpression == null || sqlExpression.equals("")) {
            debugLogger.error((Object)"SQL expression was null but should not be.");
        }
        this.dbWriteThread.setSqlExpressionToExecute(sqlExpression);
        Future<?> future = this.executorService.submit(this.dbWriteThread);
        try {
            if (future.get() != null) {
                debugLogger.error((Object)"Writing to DB using Runnable failed.");
            }
        }
        catch (InterruptedException e) {
            debugLogger.error((Object)e);
        }
        catch (ExecutionException e) {
            debugLogger.error((Object)e);
        }
    }

    private String createSetUpTablesString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE IF NOT EXISTS logEntries (");
        sb.append("id INTEGER");
        int x = 0;
        while (x < LogEntryItemType.values().length) {
            sb.append(", " + (Object)((Object)LogEntryItemType.values()[x]) + " " + this.typeGetter.getDataType(LogEntryItemType.values()[x]));
            ++x;
        }
        sb.append(", KEY `LoggingPositionID` USING HASH (`LoggingPositionID`), KEY `LoggingTraceID` USING HASH (`LoggingTraceID`), KEY `IdentifyingName` (`IdentifyingName`), KEY `CodeLine` (`CodeLine`), KEY `LoggerInvocationCount` (`LoggerInvocationCount`), KEY `LogType` (`LogType`)");
        sb.append(") ENGINE=InnoDB DEFAULT CHARSET=latin1");
        return sb.toString();
    }

    private synchronized void appendInsertToCache(ILogEntry logEntry) throws SQLException {
        if (this.cachedSqlExpressions.length() >= this.cacheCapacity) {
            this.cachedSqlExpressions.append(this.convertToInsertString(logEntry, true));
            this.executeQuery(this.cachedSqlExpressions.toString());
            this.cachedSqlExpressions = new StringBuilder(this.cacheCapacityMax);
        } else {
            this.cachedSqlExpressions.append(this.convertToInsertString(logEntry, false));
        }
    }

    private synchronized String convertToInsertString(ILogEntry logEntry, boolean finaliseInsert) {
        StringBuilder sb = new StringBuilder();
        if (this.isCachedInsertExpressionInitialised.compareAndSet(false, true)) {
            this.createSqlInsertHeader(sb);
        }
        sb.append(" (");
        sb.append(this.entryCount);
        ++this.entryCount;
        int x = 0;
        while (x < LogEntryItemType.values().length) {
            if (logEntry.getDataEntry(LogEntryItemType.values()[x]) != null) {
                sb.append(", ");
                if (!this.typeGetter.isDataTypeNumber(LogEntryItemType.values()[x])) {
                    sb.append("'");
                }
                sb.append(this.stringFormatter.formatObjectToString(logEntry.getDataEntry(LogEntryItemType.values()[x])));
                if (!this.typeGetter.isDataTypeNumber(LogEntryItemType.values()[x])) {
                    sb.append("'");
                }
            } else if (!this.typeGetter.isDataTypeNumber(LogEntryItemType.values()[x])) {
                sb.append(", ''");
            } else {
                sb.append(", ''");
            }
            ++x;
        }
        sb.append(")");
        if (!finaliseInsert) {
            sb.append(", ");
        } else {
            sb.append(";");
            this.isCachedInsertExpressionInitialised.set(false);
        }
        return sb.toString();
    }

    private synchronized void createSqlInsertHeader(StringBuilder sb) {
        sb.append("INSERT INTO logEntries (");
        sb.append("id");
        int x = 0;
        while (x < LogEntryItemType.values().length) {
            sb.append(", " + (Object)((Object)LogEntryItemType.values()[x]));
            ++x;
        }
        sb.append(") VALUES ");
    }
}

