/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger.db;

import de.uka.ipd.sdq.logger.registry.DbSettings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DatabaseConnectionFactory {
    private static Logger debugLogger = Logger.getLogger((String)DatabaseConnectionFactory.class.getName());
    private static DatabaseConnectionFactory singleton;
    private static Connection conn;

    private DatabaseConnectionFactory() {
    }

    public static Connection getSingletonDatabaseConnection(DbSettings dbSettings) throws SQLException {
        if (singleton == null) {
            singleton = new DatabaseConnectionFactory();
        }
        if (conn == null) {
            conn = DatabaseConnectionFactory.createNewDbConnection(dbSettings);
        }
        return conn;
    }

    public static Connection createNewDbConnection(DbSettings dbSettings) throws SQLException {
        return DatabaseConnectionFactory.internalCreateNewDbConnection(dbSettings);
    }

    public static void enforceNewConnection() {
        conn = null;
    }

    public static void shutdown() {
        if (conn != null) {
            try {
                Statement st = conn.createStatement();
                st.execute("SHUTDOWN");
                conn.close();
            }
            catch (SQLException e) {
                debugLogger.error((Object)"could not shutdown SQL server", (Throwable)e);
            }
        }
        conn = null;
    }

    private static Connection internalCreateNewDbConnection(DbSettings dbSettings) throws SQLException {
        Connection conn = null;
        try {
            Class.forName(dbSettings.getJDBCdriver()).newInstance();
        }
        catch (Exception ex) {
            debugLogger.error((Object)("Probably SQL driver (" + dbSettings.getJDBCdriver() + ") is not present. jar should" + " be in the class path or made part of the current jar"), (Throwable)ex);
        }
        try {
            conn = DriverManager.getConnection(dbSettings.getConnectionString(), dbSettings.getUserName(), dbSettings.getPassword());
        }
        catch (SQLException ex) {
            debugLogger.fatal((Object)("SQLException: " + ex.getMessage() + " SQLState: " + ex.getSQLState() + " VendorError: " + ex.getErrorCode()), (Throwable)ex);
        }
        return conn;
    }
}

