/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger.db;

import de.uka.ipd.sdq.logger.db.DatabaseWriter;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class AsynchronousCacheFlusher
extends Thread {
    private DatabaseWriter writerToFlush;
    private int idleTimeSeconds;
    private static Logger debugLogger = Logger.getLogger(AsynchronousCacheFlusher.class);

    public AsynchronousCacheFlusher(DatabaseWriter writerToFlush) {
        this.writerToFlush = writerToFlush;
        this.idleTimeSeconds = 10;
    }

    public AsynchronousCacheFlusher(DatabaseWriter writerToFlush, int idleTimeSeconds) {
        this.writerToFlush = writerToFlush;
        this.idleTimeSeconds = idleTimeSeconds;
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(1);
        Thread.currentThread().setName("AsynchronousCacheFlusher-" + Thread.currentThread().getName());
        while (true) {
            try {
                Thread.sleep(this.idleTimeSeconds * 1000);
            }
            catch (InterruptedException e) {
                debugLogger.warn((Object)("AsynchronousCacheFlusher was interrupted. " + e));
            }
            try {
                this.writerToFlush.flushCachedExpressions();
                continue;
            }
            catch (SQLException e) {
                debugLogger.error((Object)("Flushing the cache of DatabaseWriter failed. " + e));
                continue;
            }
            break;
        }
    }
}

