/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger.analysis;

import de.uka.ipd.sdq.logger.LoggingPositionId;
import de.uka.ipd.sdq.logger.LoggingTraceId;
import de.uka.ipd.sdq.logger.analysis.PositionVariable;
import de.uka.ipd.sdq.logger.db.Helper;
import de.uka.ipd.sdq.logger.enums.LogType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DbQuery {
    private static Logger debugLogger = Logger.getLogger(DbQuery.class);
    private Connection dbConnection;

    public DbQuery(Connection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public Map<LoggingTraceId, Map<String, Float>> getDataValuesForPositionId(LoggingPositionId loggingPositionId) throws SQLException {
        Statement st = this.dbConnection.createStatement(1004, 1007);
        String expression = "SELECT LoggingTraceID, IdentifyingName, ValueObject FROM logEntries WHERE LoggingPositionID = '" + loggingPositionId + "' ";
        ResultSet rs = st.executeQuery(expression);
        Helper.dump(rs, "getDataValuesForPositionId (LoggingTraceID / IdentifyingName / ValueObject)");
        HashMap<LoggingTraceId, Map<String, Float>> returnMap = new HashMap<LoggingTraceId, Map<String, Float>>();
        rs.beforeFirst();
        while (rs.next()) {
            LoggingTraceId currentLoggingTraceID = new LoggingTraceId(rs.getString("LoggingTraceID"));
            if (returnMap.containsKey(currentLoggingTraceID)) {
                ((Map)returnMap.get(currentLoggingTraceID)).put(rs.getString("IdentifyingName"), Float.valueOf(rs.getFloat("ValueObject")));
                continue;
            }
            HashMap<String, Float> newHashMap = new HashMap<String, Float>();
            newHashMap.put(rs.getString("IdentifyingName"), Float.valueOf(rs.getFloat("ValueObject")));
            returnMap.put(currentLoggingTraceID, newHashMap);
        }
        st.close();
        return returnMap;
    }

    public float[] getDataValueForPositionIdAndVariable(PositionVariable positionVariable) throws SQLException {
        throw new RuntimeException("Not Implemented");
    }

    public Map<LoggingTraceId, Float> getDataValueForPositionIdAndVariable(LoggingPositionId loggingPositionId, String variableName) throws SQLException {
        Statement st = this.dbConnection.createStatement(1004, 1007);
        String expression = "SELECT DISTINCT LoggingTraceID, ValueObject FROM logEntries WHERE LoggingPositionID = '" + loggingPositionId + "' AND " + "IdentifyingName = '" + variableName + "' ";
        ResultSet rs = st.executeQuery(expression);
        Helper.dump(rs, "getDataValueForPositionIdAndVariable (LoggingTraceID / ValueObject)");
        HashMap<LoggingTraceId, Float> returnMap = new HashMap<LoggingTraceId, Float>();
        rs.beforeFirst();
        while (rs.next()) {
            returnMap.put(new LoggingTraceId(rs.getString("LoggingTraceID")), Float.valueOf(rs.getFloat("ValueObject")));
        }
        st.close();
        return returnMap;
    }

    public Map<LoggingTraceId, Float> getDataValueForPositionId(LoggingPositionId loggingPositionId) throws SQLException {
        Statement st = this.dbConnection.createStatement(1004, 1007);
        String expression = "SELECT DISTINCT LoggingTraceID, ValueObject FROM logEntries WHERE LoggingPositionID = '" + loggingPositionId + "'";
        ResultSet rs = st.executeQuery(expression);
        Helper.dump(rs, "getDataValueForPositionId (LoggingTraceID / ValueObject)");
        HashMap<LoggingTraceId, Float> returnMap = new HashMap<LoggingTraceId, Float>();
        rs.beforeFirst();
        while (rs.next()) {
            returnMap.put(new LoggingTraceId(rs.getString("LoggingTraceID")), Float.valueOf(rs.getFloat("ValueObject")));
        }
        st.close();
        return returnMap;
    }

    public List<LoggingTraceId> getTraceIdsForPositionId(LoggingPositionId loggingPositionId) throws SQLException {
        Statement st = this.dbConnection.createStatement(1004, 1007);
        ResultSet rs = null;
        String expression = "SELECT DISTINCT LoggingTraceID FROM logEntries WHERE LoggingPositionID = '" + loggingPositionId + "' ";
        rs = st.executeQuery(expression);
        ArrayList<LoggingTraceId> returnList = new ArrayList<LoggingTraceId>();
        rs.beforeFirst();
        while (rs.next()) {
            returnList.add(new LoggingTraceId(rs.getString("LoggingTraceID")));
        }
        st.close();
        return returnList;
    }

    public LogType getLogTypeForPositionId(LoggingPositionId loggingPositionId, String identifyingName) throws SQLException {
        LogType returnLogType;
        Statement st = this.dbConnection.createStatement(1004, 1007);
        ResultSet rs = null;
        String expression = "SELECT DISTINCT LogType FROM logEntries WHERE LoggingPositionID = '" + loggingPositionId + "' ";
        if (identifyingName != null && !identifyingName.equals("")) {
            expression = String.valueOf(expression) + " AND IdentifyingName = '" + identifyingName + "' ";
        }
        rs = st.executeQuery(expression);
        Helper.dump(rs, "getLogTypeForPositionId -- LoggingPositionID: " + loggingPositionId + ", identifyingName: " + identifyingName);
        rs.beforeFirst();
        rs.next();
        String queriedLogType = rs.getString("LogType");
        try {
            try {
                returnLogType = LogType.valueOf(LogType.class, queriedLogType);
            }
            catch (IllegalArgumentException e) {
                debugLogger.error((Object)"No valid LogType", (Throwable)e);
                st.close();
                throw new RuntimeException("Invalid LogType queried");
            }
        }
        finally {
            st.close();
        }
        return returnLogType;
    }

    public class TraceIdVariableTuple {
        public String variableName;
        public String traceId;

        public TraceIdVariableTuple(String traceId, String variableName) {
            this.variableName = variableName;
            this.traceId = traceId;
        }
    }

    public class VariableValue {
        public String variableName;
        public float variableValue;

        public VariableValue(String variableName, float variableValue) {
            this.variableName = variableName;
            this.variableValue = variableValue;
        }
    }
}

