/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger.analysis;

import de.uka.ipd.sdq.logger.LoggingPositionId;
import de.uka.ipd.sdq.logger.LoggingTraceId;
import de.uka.ipd.sdq.logger.db.Helper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class DataAggregation {
    private static Logger debugLogger = Logger.getLogger((String)DataAggregation.class.getName());
    private Connection dbConnection;

    public DataAggregation(Connection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public Map<LoggingTraceId, Integer> aggregateLoopCountsFor(LoggingPositionId loggingPositionId) throws SQLException {
        List<Integer> startingPositionsOfNestedLoops = this.getStartingPositionLogIdsOfNestedLoops(loggingPositionId);
        Map<LoggingTraceId, Integer> returnCounts = startingPositionsOfNestedLoops.size() == 0 ? this.aggregateIterationCountsForOuterLoop(loggingPositionId) : this.aggregateIterationCountsForNestedLoop(loggingPositionId, startingPositionsOfNestedLoops.get(0), startingPositionsOfNestedLoops.get(1));
        debugLogger.debug((Object)("trace / counts: " + returnCounts));
        return returnCounts;
    }

    private Map<LoggingTraceId, Integer> aggregateIterationCountsForOuterLoop(LoggingPositionId loggingPositionId) throws SQLException {
        Statement st = null;
        st = this.dbConnection.createStatement(1004, 1007);
        ResultSet rs = null;
        String expression = "SELECT LoggingTraceId, COUNT(`LoggingPositionID`) AS count FROM logEntries WHERE LoggingPositionID = '" + loggingPositionId + "' " + "GROUP BY `LoggingTraceID`, `LoggingPositionID` ";
        rs = this.executeQueryAndLogTime(st, expression, "aggregateIterationCountsForOuterLoop");
        Helper.dump(rs, "aggregateIterationCountsForOuterLoop");
        HashMap<LoggingTraceId, Integer> returnCounts = new HashMap<LoggingTraceId, Integer>();
        rs.beforeFirst();
        while (rs.next()) {
            returnCounts.put(new LoggingTraceId(rs.getString("LoggingTraceId")), rs.getInt("count"));
        }
        st.close();
        return returnCounts;
    }

    private Map<LoggingTraceId, Integer> aggregateIterationCountsForNestedLoop(LoggingPositionId loggingPositionId, int lowerId, int upperId) throws SQLException {
        Statement st = null;
        st = this.dbConnection.createStatement(1004, 1007);
        ResultSet rs = null;
        String expression = "SELECT LoggingTraceId, COUNT(`LoggingPositionID`) as count FROM logEntries WHERE id >= " + lowerId + " AND " + "id < " + upperId + " AND " + "LoggingPositionID = '" + loggingPositionId + "' " + "GROUP BY `LoggingTraceID`, `LoggingPositionID`";
        rs = this.executeQueryAndLogTime(st, expression, "aggregateIterationCountsForNestedLoop");
        Helper.dump(rs, "aggregateIterationCountsForNestedLoop");
        HashMap<LoggingTraceId, Integer> returnCounts = new HashMap<LoggingTraceId, Integer>();
        rs.beforeFirst();
        while (rs.next()) {
            returnCounts.put(new LoggingTraceId(rs.getString("LoggingTraceId")), rs.getInt("count"));
        }
        st.close();
        return returnCounts;
    }

    private List<Integer> getStartingPositionLogIdsOfNestedLoops(LoggingPositionId loggingPositionId) throws SQLException {
        Statement st = null;
        st = this.dbConnection.createStatement(1004, 1007);
        ResultSet rs = null;
        String expression = "SELECT searched.id AS searchedID, searched.Date, searched.LoggerInvocationCount, searched.CodeLine, searched.IdentifyingName FROM logEntries compared, logEntries searched WHERE compared.CodeLine < searched.CodeLine AND compared.LoggerInvocationCount = (searched.LoggerInvocationCount-1) AND compared.LoggingPositionID <> searched.LoggingPositionID AND compared.LogType = 'InIteratorStatement' AND searched.LogType = 'InIteratorStatement' AND searched.LoggingPositionID = '" + loggingPositionId + "' " + "GROUP BY searched.LoggingTraceID, searched.id ";
        rs = this.executeQueryAndLogTime(st, expression, "getStartingPositionLogIdsOfNestedLoops");
        ArrayList<Integer> returnPositions = new ArrayList<Integer>();
        rs.beforeFirst();
        while (rs.next()) {
            returnPositions.add(rs.getInt("searchedID"));
        }
        st.close();
        return returnPositions;
    }

    private ResultSet executeQueryAndLogTime(Statement st, String sqlExpression, String queryName) throws SQLException {
        ResultSet rs = null;
        long startTime = System.currentTimeMillis();
        rs = st.executeQuery(sqlExpression);
        long timeTaken = System.currentTimeMillis() - startTime;
        debugLogger.debug((Object)("Query " + queryName + " took " + TimeUnit.MILLISECONDS.toSeconds(timeTaken) + "s (" + TimeUnit.MILLISECONDS.toMinutes(timeTaken) + "min)."));
        return rs;
    }
}

