/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger;

import de.uka.ipd.sdq.logger.Logger;
import de.uka.ipd.sdq.logger.enums.LogType;
import de.uka.ipd.sdq.logger.registry.Settings;
import de.uka.ipd.sdq.logger.rmi.ILogServer;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class LoggerFactory {
    private static org.apache.log4j.Logger debugLogger = org.apache.log4j.Logger.getLogger((String)LoggerFactory.class.getName());

    public static Logger createLogger(String localInstanceName, String fullQualifiedClassName) {
        Logger logger = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        try {
            Registry registry = LocateRegistry.getRegistry(new Settings().getRmiPort());
            ILogServer logServer = (ILogServer)registry.lookup(new Settings().getRmiServerClass());
            debugLogger.info((Object)"RMI Client ready.");
            logger = logServer.getPreconfiguredLogger(localInstanceName, fullQualifiedClassName);
            debugLogger.debug((Object)"Logger created using RMI shared settings.");
        }
        catch (RemoteException e) {
            debugLogger.error((Object)("Client creation (RMI) failed. (Maybe your libraries are out of sync between server and client.) " + e.getMessage()));
        }
        catch (NotBoundException e) {
            debugLogger.error((Object)("Client creation (RMI) failed. (Maybe your libraries are out of sync between server and client.) " + e.getMessage()));
        }
        return logger;
    }

    public static void main(String[] args) {
        Logger logger = LoggerFactory.createLogger("", null);
        logger.addLogEntryTimestamp(LogType.Comment, "test");
        logger.addLogEntry(LogType.Comment, "test2");
        debugLogger.debug((Object)"added two log entries.");
    }
}

