/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger;

import de.uka.ipd.sdq.logger.LogEntry;
import de.uka.ipd.sdq.logger.LoggingPositionIdGenerator;
import de.uka.ipd.sdq.logger.db.DatabaseWriter;
import de.uka.ipd.sdq.logger.enums.LogDataType;
import de.uka.ipd.sdq.logger.enums.LogEntryItemType;
import de.uka.ipd.sdq.logger.enums.LogType;
import de.uka.ipd.sdq.logger.registry.DbSettings;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.spi.LocationInfo;

public class Logger
implements Serializable {
    private static final long serialVersionUID = -4606296915244014220L;
    private transient DatabaseWriter databaseWriter;
    private final String localInstanceName;
    private final String loggedfullQualifiedClassNameObject;
    private final long testRunNumber;
    private AtomicLong loggerInvocationCount;
    private AtomicLong methodExecutionCount;
    private boolean automaticLogLineAndMethod;
    private boolean deactivated;
    private DbSettings dbSettings;

    protected Logger(String localInstanceName, String fullQualifiedClassName, long testRunNumber, DbSettings dbSettings) {
        this.localInstanceName = localInstanceName;
        this.loggedfullQualifiedClassNameObject = fullQualifiedClassName;
        this.testRunNumber = testRunNumber;
        this.automaticLogLineAndMethod = false;
        this.loggerInvocationCount = new AtomicLong(0L);
        this.methodExecutionCount = new AtomicLong(0L);
        this.deactivated = false;
        this.dbSettings = dbSettings;
    }

    public void setAutomaticLogLineAndMethodMode(boolean isEnabled) {
        this.automaticLogLineAndMethod = isEnabled;
    }

    public void deactivateLogger() {
        this.deactivated = true;
    }

    public void reactivateLogger() {
        this.deactivated = false;
    }

    public void addLogEntry(LogType logType, String method, int codeLine, LogDataType logDataType, String identifyingName, Object valueObject, String comment) {
        if (!this.deactivated) {
            String methodName;
            LogEntry logEntry = new LogEntry();
            logEntry.addData(LogEntryItemType.Date, System.nanoTime());
            logEntry.addData(LogEntryItemType.TestRunNumber, this.testRunNumber);
            logEntry.addData(LogEntryItemType.LoggerInvocationCount, this.loggerInvocationCount.get());
            logEntry.addData(LogEntryItemType.Logger, this.localInstanceName);
            if (this.loggedfullQualifiedClassNameObject != null) {
                logEntry.addData(LogEntryItemType.Class, this.loggedfullQualifiedClassNameObject);
            } else {
                logEntry.addData(LogEntryItemType.Class, "null");
            }
            if (method.charAt(method.length() - 1) == ' ') {
                method = method.substring(0, method.length() - 1);
            }
            logEntry.addData(LogEntryItemType.Method, method);
            logEntry.addData(LogEntryItemType.CodeLine, codeLine);
            logEntry.addData(LogEntryItemType.LogType, (Object)logType);
            logEntry.addData(LogEntryItemType.LogDataType, (Object)logDataType);
            logEntry.addData(LogEntryItemType.IdentifyingName, identifyingName);
            logEntry.addData(LogEntryItemType.ValueObject, valueObject);
            logEntry.addData(LogEntryItemType.Comment, comment);
            logEntry.addData(LogEntryItemType.ThreadID, Thread.currentThread().getId());
            logEntry.addData(LogEntryItemType.ThreadName, Thread.currentThread().getName());
            if (this.automaticLogLineAndMethod) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < stackTrace.length) {
                    sb.append(" >>> " + Thread.currentThread().getStackTrace()[i].getClassName() + ": " + Thread.currentThread().getStackTrace()[i].getMethodName() + "(" + Thread.currentThread().getStackTrace()[i].getLineNumber() + ")");
                    ++i;
                }
                logEntry.addData(LogEntryItemType.StackTrace, sb.toString());
                assert (this.loggedfullQualifiedClassNameObject.getClass().equals(String.class));
                LocationInfo locationInfo = new LocationInfo(new Throwable(), "de.uka.ipd.sdq.logger.Logger.addLogEntry");
                logEntry.addData(LogEntryItemType.CodeLine, locationInfo.getLineNumber());
                codeLine = Integer.parseInt(locationInfo.getLineNumber());
                logEntry.addData(LogEntryItemType.Method, locationInfo.getMethodName());
                methodName = locationInfo.getMethodName();
            } else if (method != null) {
                methodName = method;
            } else {
                methodName = "";
                System.err.println("Method name should be properly set; otherwise ID generation will fail");
            }
            byte[] locationHash = LoggingPositionIdGenerator.createLoggingPositionID(this.loggedfullQualifiedClassNameObject, methodName, codeLine);
            logEntry.addData(LogEntryItemType.LoggingPositionID, locationHash);
            byte[] traceHash = this.createTraceID(methodName);
            logEntry.addData(LogEntryItemType.LoggingTraceID, traceHash);
            this.getDatabaseWriter().writeLogEntryToDatabase(logEntry);
            this.loggerInvocationCount.incrementAndGet();
        }
    }

    private byte[] createTraceID(String methodName) {
        StringBuilder hashString = new StringBuilder();
        hashString.append(this.localInstanceName);
        hashString.append(this.loggedfullQualifiedClassNameObject.getClass().getName());
        hashString.append(methodName);
        hashString.append(Thread.currentThread().getId());
        hashString.append(this.testRunNumber);
        hashString.append(this.methodExecutionCount.get());
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return md.digest(hashString.toString().getBytes());
    }

    public void newMethodInvocation() {
        this.methodExecutionCount.incrementAndGet();
    }

    public void addLogEntry2(LogType logType, Method method, int codeLine, LogDataType logDataType, String identifyingName, Object valueObject, String comment) {
        this.addLogEntry(logType, method.getName(), codeLine, logDataType, identifyingName, valueObject, comment);
    }

    public void addLogEntry(LogType logType, String method, LogDataType logDataType, String identifyingName, Object valueObject) {
        this.addLogEntry(logType, method, -1, logDataType, identifyingName, valueObject, "");
    }

    public void addLogEntry(LogType logType, String method, LogDataType logDataType, String identifyingName) {
        this.addLogEntry(logType, method, -1, logDataType, identifyingName, null, "");
    }

    public void addLogEntry(LogType logType, String method, int codeLine, String identifyingName) {
        this.addLogEntry(logType, method, codeLine, LogDataType.Timestamp, identifyingName, null, "-timestamp-");
    }

    public void addLogEntry(LogType logType, LogDataType logDataType, String identifyingName, Object valueObject) {
        this.addLogEntry(logType, null, -1, logDataType, identifyingName, valueObject, "");
    }

    public void addLogEntryData(LogType logType, LogDataType logDataType, String identifyingName, Object valueObject) {
        this.addLogEntry(logType, null, -1, logDataType, identifyingName, valueObject, "");
    }

    public void addLogEntry(LogType logType, String identifyingName) {
        this.addLogEntry(logType, null, -1, LogDataType.Timestamp, identifyingName, null, "-timestamp-");
    }

    public void addLogEntryTimestamp(LogType logType, String identifyingName) {
        this.addLogEntry(logType, null, -1, LogDataType.Timestamp, identifyingName, null, "-timestamp-");
    }

    private DatabaseWriter getDatabaseWriter() {
        if (this.databaseWriter == null) {
            this.databaseWriter = new DatabaseWriter(this.dbSettings);
        }
        return this.databaseWriter;
    }
}

