/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger;

import de.uka.ipd.sdq.logger.ILogEntry;
import de.uka.ipd.sdq.logger.LogFilter;
import de.uka.ipd.sdq.logger.enums.LogEntryItemType;
import de.uka.ipd.sdq.logger.stringformatters.ObjectToStringFormatter;

public class LogPrinter {
    private ObjectToStringFormatter stringFormatter = new ObjectToStringFormatter();
    private String valueSeparator = " | ";
    private String headerSeparator = "-";
    private String itemPrefix = "";
    private String itemPostfix = "\n";
    private boolean printHeader = true;
    private boolean printIdentifier = false;
    private String identifierSeparator = ": ";
    private int tabWidth = 30;

    public String print(ILogEntry logEntry, LogFilter logFilter) {
        boolean first = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.itemPrefix);
        int x = 0;
        while (x < LogEntryItemType.values().length) {
            if (logFilter.getFilterOption(LogEntryItemType.values()[x])) {
                if (!first) {
                    stringBuilder.append(this.valueSeparator);
                }
                first = false;
                String valueString = "";
                if (logEntry != null) {
                    valueString = this.stringFormatter.formatObjectToString(logEntry.getDataEntry(LogEntryItemType.values()[x]));
                }
                stringBuilder.append(this.printSingleElement(LogEntryItemType.values()[x].toString(), valueString));
            }
            ++x;
        }
        stringBuilder.append(this.itemPostfix);
        return stringBuilder.toString();
    }

    public String printColumnHeader(LogFilter logFilter) {
        boolean printIdentifierTemp = this.printIdentifier;
        this.printIdentifier = true;
        String string = this.print(null, logFilter);
        if (this.headerSeparator != null && !this.headerSeparator.equals("")) {
            string = String.valueOf(string) + this.chars(logFilter.getNumberOfActiveOutputs() * this.tabWidth, this.headerSeparator) + this.itemPostfix;
        }
        this.printIdentifier = printIdentifierTemp;
        return string;
    }

    private String printSingleElement(String fieldName, String fieldvalue) {
        StringBuilder string = new StringBuilder();
        if (this.printIdentifier) {
            string.append(fieldName);
            string.append(this.identifierSeparator);
        }
        string.append(fieldvalue);
        if (string.length() + this.valueSeparator.length() < this.tabWidth && this.tabWidth != -1) {
            string.append(this.spaces(this.tabWidth - string.length() - this.valueSeparator.length()));
        }
        return string.toString();
    }

    private String spaces(int numberOfSpaces) {
        return this.chars(numberOfSpaces, " ");
    }

    private String chars(int numberOfChars, String singleChar) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < numberOfChars) {
            s.append(singleChar);
            ++i;
        }
        return s.toString();
    }

    public void setItemPrefix(String itemPrefix) {
        this.itemPrefix = itemPrefix;
    }

    public void setPrintIdentifier(boolean printIdentifier) {
        this.printIdentifier = printIdentifier;
    }

    public void setValueSeparator(String separator) {
        this.valueSeparator = separator;
    }

    public void setItemPostfix(String itemPostfix) {
        this.itemPostfix = itemPostfix;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public void setHeaderSeparator(String headerSeparator) {
        this.headerSeparator = headerSeparator;
    }

    public void setIdentifierSeparator(String identifierSeparator) {
        this.identifierSeparator = identifierSeparator;
    }

    public void setPrintHeader(boolean printHeader) {
        this.printHeader = printHeader;
    }
}

