/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger;

import de.uka.ipd.sdq.logger.ILogEntry;
import de.uka.ipd.sdq.logger.LogFilter;
import de.uka.ipd.sdq.logger.LogPrinter;
import de.uka.ipd.sdq.logger.Logger;
import de.uka.ipd.sdq.logger.db.DatabaseConnectionFactory;
import de.uka.ipd.sdq.logger.db.DatabaseWriter;
import de.uka.ipd.sdq.logger.enums.LoggerStatus;
import de.uka.ipd.sdq.logger.registry.DbSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class Log
implements Serializable {
    private static final long serialVersionUID = -1049766959601216365L;
    private static StringBuilder cachedStringBuilder;
    private static LogPrinter cachedLogPrinter;
    private static LogFilter cachedLogFilter;
    private static boolean cacheValid;
    private static boolean writeToFileOnDestructionEnabled;
    private static LogPrinter onDestructionLogPrinter;
    private static LogFilter onDestructionLogFilter;
    private static File onDestructionFileToWriteTo;
    private static org.apache.log4j.Logger debugLogger;
    private static Log logSingleton;
    private static long starttime;
    private static AtomicLong testRunNumber;
    private static ArrayList<ILogEntry> logEntries;
    private static DbSettings dbSettings;
    private static Connection databaseConnection;
    private static DatabaseWriter databaseWriter;

    static {
        cacheValid = true;
        writeToFileOnDestructionEnabled = false;
        debugLogger = org.apache.log4j.Logger.getLogger((String)Log.class.getName());
    }

    private Log() {
        starttime = new Date().getTime();
        testRunNumber = new AtomicLong(0L);
        logEntries = new ArrayList();
        dbSettings = new DbSettings();
        try {
            databaseConnection = DatabaseConnectionFactory.createNewDbConnection(dbSettings);
        }
        catch (SQLException e) {
            debugLogger.error((Object)"Could not establish DB connection.", (Throwable)e);
        }
        databaseWriter = new DatabaseWriter(dbSettings);
        databaseWriter.dropEntriesTable();
        databaseWriter.initDatabase();
    }

    private static synchronized void grantInit() {
        if (logSingleton == null) {
            logSingleton = new Log();
        }
    }

    protected static synchronized Logger getLogger(String localInstanceName, String fullQualifiedClassName) {
        Log.grantInit();
        Logger logger = new Logger(localInstanceName, fullQualifiedClassName, testRunNumber.get(), dbSettings);
        Log.increaseTestRunNumber();
        return logger;
    }

    protected static synchronized Logger getLogger(String localInstanceName, String fullQualifiedClassName, LoggerStatus status) {
        Log.grantInit();
        Logger logger = new Logger(localInstanceName, fullQualifiedClassName, testRunNumber.get(), dbSettings);
        if (status == LoggerStatus.DEACTIVATED) {
            logger.deactivateLogger();
        }
        Log.increaseTestRunNumber();
        return logger;
    }

    public static synchronized Logger getRmiLogger(String localInstanceName, String fullQualifiedClassName) {
        return Log.getLogger(localInstanceName, fullQualifiedClassName);
    }

    public synchronized void addLogEntry(ILogEntry logEntry) {
        databaseWriter.writeLogEntryToDatabase(logEntry);
        logEntries.add(logEntry);
        cacheValid = false;
    }

    public static void WriteToConsole(LogPrinter logPrinter, LogFilter logFilter) {
        Log.grantInit();
        long totaltime = new Date().getTime() - starttime;
        debugLogger.log((Priority)Level.INFO, (Object)("Run took " + totaltime + " ms.\n\n"));
        System.out.println(Log.createLogOutputString(logPrinter, logFilter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void WriteToFile(LogPrinter logPrinter, LogFilter logFilter, File file) {
        block19: {
            Log.grantInit();
            debugLogger.log((Priority)Level.INFO, (Object)"Writing file...");
            FileOutputStream s = null;
            try {
                FileOutputStream fileOutputStream = s = new FileOutputStream(file, false);
                synchronized (fileOutputStream) {
                    s.write(Log.createLogOutputString(logPrinter, logFilter).getBytes());
                }
            }
            catch (FileNotFoundException e) {
                debugLogger.error((Object)"Error on writing log file.", (Throwable)e);
                try {
                    s.close();
                }
                catch (IOException ioe) {
                    debugLogger.error((Object)"Error. Could no close log file handle.", (Throwable)ioe);
                }
                break block19;
            }
            catch (IOException ioe) {
                try {
                    debugLogger.error((Object)"Error on writing log file.", (Throwable)ioe);
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        s.close();
                    }
                    catch (IOException ioe2) {
                        debugLogger.error((Object)"Error. Could no close log file handle.", (Throwable)ioe2);
                    }
                }
            }
            try {
                s.close();
            }
            catch (IOException ioe) {
                debugLogger.error((Object)"Error. Could no close log file handle.", (Throwable)ioe);
            }
        }
        debugLogger.info((Object)"Writing file... done.");
    }

    public static void writeToFileOnDestruction(LogPrinter logPrinter, LogFilter logFilter, File file) {
        Log.grantInit();
        if (writeToFileOnDestructionEnabled) {
            debugLogger.info((Object)"writeToFileOnDestruction(..) called before. Overwriting settings.");
        }
        writeToFileOnDestructionEnabled = true;
        onDestructionLogPrinter = logPrinter;
        onDestructionLogFilter = logFilter;
        onDestructionFileToWriteTo = file;
    }

    protected void finalize() {
        if (writeToFileOnDestructionEnabled) {
            Log.WriteToFile(onDestructionLogPrinter, onDestructionLogFilter, onDestructionFileToWriteTo);
        }
        try {
            databaseConnection.close();
        }
        catch (SQLException e) {
            debugLogger.error((Object)("Problem closing DB connection in Log: " + e + " " + e.getMessage()));
        }
    }

    public static Iterator<ILogEntry> getLogEntryIterator() {
        Log.grantInit();
        return logEntries.iterator();
    }

    public static List<ILogEntry> getLogEntryList() {
        Log.grantInit();
        return logEntries;
    }

    public static void invalidateCache() {
        Log.grantInit();
        cachedStringBuilder = null;
        cachedLogPrinter = null;
        cachedLogFilter = null;
        System.gc();
        cacheValid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String createLogOutputString(LogPrinter logPrinter, LogFilter logFilter) {
        Log.grantInit();
        if (!cacheValid || cachedLogFilter != logFilter || cachedLogPrinter != logPrinter) {
            cachedStringBuilder = new StringBuilder();
            cachedStringBuilder.append(logPrinter.printColumnHeader(logFilter));
            ArrayList<ILogEntry> arrayList = logEntries;
            synchronized (arrayList) {
                Iterator<ILogEntry> it = logEntries.iterator();
                while (it.hasNext()) {
                    cachedStringBuilder.append(logPrinter.print(it.next(), logFilter));
                }
            }
        }
        cacheValid = true;
        return cachedStringBuilder.toString();
    }

    public static void increaseTestRunNumber() {
        Log.grantInit();
        testRunNumber.incrementAndGet();
    }
}

