/*
 * Decompiled with CFR 0.152.
 */
package checker.jpfbpc;

import gov.nasa.jpf.PropertyListenerAdapter;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.Step;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Transition;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.bytecode.ReturnInstruction;
import gov.nasa.jpf.search.Search;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.objectweb.fractal.bpc.checker.DFSR.JPFTraverser;

public class ProtocolListener
extends PropertyListenerAdapter {
    private Stack transitions = new Stack();
    private Map methods2events = null;
    private Set serverClasses = null;
    private JPFTraverser traverser = null;
    private boolean checkFailed = false;
    private boolean endStateOccured = false;
    private boolean errorReported = false;

    public ProtocolListener(JPFTraverser tr, Map itf2class, Set serverItfs, String[] events) {
        this.methods2events = this.createMethods2Events(itf2class, events);
        this.serverClasses = this.createServerClasses(serverItfs, itf2class);
        this.traverser = tr;
    }

    public Set getMethodNames() {
        if (this.methods2events == null) {
            return new HashSet();
        }
        return this.methods2events.keySet();
    }

    public void stateAdvanced(Search search) {
        Transition tr = search.getTransition();
        List ptr = this.extractProtocolTransition(tr);
        this.transitions.push(ptr);
        this.moveForward(ptr);
        if (search.isEndState()) {
            this.endStateOccured = true;
            if (!this.traverser.notifyEnd()) {
                this.checkFailed = true;
            }
        }
    }

    public void stateBacktracked(Search search) {
        List ptr = (List)this.transitions.pop();
        this.moveBackward(ptr);
    }

    public void stateProcessed(Search search) {
        if (search.isEndState()) {
            this.endStateOccured = true;
            if (!this.traverser.notifyEnd()) {
                this.checkFailed = true;
            }
        }
    }

    public void searchFinished(Search search) {
        if (!this.checkFailed && !this.endStateOccured) {
            System.err.println("Warning: no end state occured - there is probably an infinite loop or a deadlock in the code");
        }
    }

    public void instructionExecuted(JVM vm) {
        Instruction instr = vm.getLastInstruction();
        ThreadInfo ti = vm.getLastThreadInfo();
        if (instr instanceof InvokeInstruction) {
            InvokeInstruction invokeInstr = (InvokeInstruction)instr;
            MethodInfo mi = invokeInstr.getInvokedMethod();
            String className = this.getClassName(mi);
            String methodName = this.getMethodName(mi);
            String fullMethodName = className + "." + methodName;
            String event = (String)this.methods2events.get(fullMethodName);
            if (event != null) {
                ti.breakTransition();
            }
        } else if (instr instanceof ReturnInstruction) {
            MethodInfo mi = instr.getMethodInfo();
            String className = this.getClassName(mi);
            String methodName = this.getMethodName(mi);
            String fullMethodName = className + "." + methodName;
            String event = (String)this.methods2events.get(fullMethodName);
            if (event != null) {
                ti.breakTransition();
            }
        }
    }

    public boolean check(Search search, JVM vm) {
        if (this.errorReported) {
            return true;
        }
        if (this.checkFailed) {
            this.errorReported = true;
        }
        return !this.checkFailed;
    }

    public String getErrorMessage() {
        return "Tested component is not compliant with the protocol";
    }

    private void moveForward(List protoTrans) {
        for (int i = 0; i < protoTrans.size(); ++i) {
            Object protoEvent = protoTrans.get(i);
            if (protoEvent instanceof ProtocolInvoke) {
                ProtocolInvoke protoInv = (ProtocolInvoke)protoEvent;
                if (this.checkFailed || this.traverser.notifyForwardInvoke(protoInv.thread, protoInv.isClientEvent, protoInv.event)) continue;
                this.checkFailed = true;
                continue;
            }
            if (!(protoEvent instanceof ProtocolReturn)) continue;
            ProtocolReturn protoRet = (ProtocolReturn)protoEvent;
            if (this.checkFailed || this.traverser.notifyForwardReturn(protoRet.thread, protoRet.isClientEvent, protoRet.event)) continue;
            this.checkFailed = true;
        }
    }

    private void moveBackward(List protoTrans) {
        for (int i = protoTrans.size() - 1; i >= 0; --i) {
            Object protoEvent = protoTrans.get(i);
            if (protoEvent instanceof ProtocolInvoke) {
                ProtocolInvoke protoInv = (ProtocolInvoke)protoEvent;
                if (this.checkFailed || this.traverser.notifyBackwardInvoke(protoInv.thread, protoInv.isClientEvent, protoInv.event)) continue;
                this.checkFailed = true;
                continue;
            }
            if (!(protoEvent instanceof ProtocolReturn)) continue;
            ProtocolReturn protoRet = (ProtocolReturn)protoEvent;
            if (this.checkFailed || this.traverser.notifyBackwardReturn(protoRet.thread, protoRet.isClientEvent, protoRet.event)) continue;
            this.checkFailed = true;
        }
    }

    private List extractProtocolTransition(Transition trans) {
        ArrayList<Object> protoTrans = new ArrayList<Object>();
        for (Step step : trans) {
            Instruction instr = step.getInstruction();
            if (instr instanceof InvokeInstruction) {
                InvokeInstruction invokeInstr = (InvokeInstruction)instr;
                MethodInfo mi = invokeInstr.getInvokedMethod();
                String className = this.getClassName(mi);
                String methodName = this.getMethodName(mi);
                String fullMethodName = className + "." + methodName;
                String event = (String)this.methods2events.get(fullMethodName);
                if (event == null) continue;
                ProtocolInvoke protoInv = new ProtocolInvoke(trans.getThreadIndex(), !this.serverClasses.contains(className), event);
                protoTrans.add(protoInv);
                continue;
            }
            if (!(instr instanceof ReturnInstruction)) continue;
            MethodInfo mi = instr.getMethodInfo();
            String className = this.getClassName(mi);
            String methodName = this.getMethodName(mi);
            String fullMethodName = className + "." + methodName;
            String event = (String)this.methods2events.get(fullMethodName);
            if (event == null) continue;
            ProtocolReturn protoRet = new ProtocolReturn(trans.getThreadIndex(), !this.serverClasses.contains(className), event);
            protoTrans.add(protoRet);
        }
        return protoTrans;
    }

    private String getClassName(MethodInfo mi) {
        if (mi == null) {
            return "";
        }
        if (mi.getClassInfo() == null) {
            return "";
        }
        return mi.getClassInfo().getName();
    }

    private String getMethodName(MethodInfo mi) {
        if (mi == null) {
            return "";
        }
        return mi.getName();
    }

    private Map createMethods2Events(Map itf2class, String[] events) {
        HashMap<String, String> m2e = new HashMap<String, String>();
        for (int i = 0; i < events.length; ++i) {
            String evClass;
            String event = events[i];
            String evItf = "";
            String evMethod = "";
            int k = event.indexOf(46);
            if (k != -1) {
                evItf = event.substring(0, k);
                evMethod = event.substring(k + 1);
            }
            if ((evClass = (String)itf2class.get(evItf)) == null || evMethod.length() <= 0) continue;
            m2e.put(evClass + "." + evMethod, event);
        }
        return m2e;
    }

    private Set createServerClasses(Set serverItfs, Map itf2class) {
        HashSet<String> sc = new HashSet<String>();
        for (String itf : serverItfs) {
            String cls = (String)itf2class.get(itf);
            if (cls == null) continue;
            sc.add(cls);
        }
        return sc;
    }

    class ProtocolReturn {
        protected int thread;
        protected boolean isClientEvent;
        protected String event;

        ProtocolReturn(int thread, boolean isClientEvent, String event) {
            this.thread = thread;
            this.isClientEvent = isClientEvent;
            this.event = event;
        }
    }

    class ProtocolInvoke {
        protected int thread;
        protected boolean isClientEvent;
        protected String event;

        ProtocolInvoke(int thread, boolean isClientEvent, String event) {
            this.thread = thread;
            this.isClientEvent = isClientEvent;
            this.event = event;
        }
    }
}

