/*
 * Decompiled with CFR 0.152.
 */
package checker.jpfbpc;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.search.Search;
import org.objectweb.fractal.bpc.checker.DFSR.JPFTraverser;

public class JPFCheckerSearch
extends Search {
    private JPFTraverser traverser = null;

    public JPFCheckerSearch(Config config, JVM vm) throws Config.Exception {
        super(config, vm);
    }

    public boolean requestBacktrack() {
        this.doBacktrack = true;
        return true;
    }

    public void setJPFTraverser(JPFTraverser jt) {
        this.traverser = jt;
    }

    public void search() {
        int maxDepth = this.getMaxSearchDepth();
        this.depth = 0;
        this.notifySearchStarted();
        while (!this.done) {
            if (!this.isNewState && this.traverser.wantsBacktrack() || this.isEndState) {
                if (!this.backtrack()) break;
                --this.depth;
                this.notifyStateBacktracked();
            }
            if (this.forward()) {
                this.notifyStateAdvanced();
                if (this.hasPropertyTermination()) break;
                ++this.depth;
                if (this.depth < maxDepth) continue;
                this.isEndState = true;
                this.notifySearchConstraintHit("Seqrch Queue Size");
                continue;
            }
            this.notifyStateProcessed();
        }
        this.notifySearchFinished();
        this.hasPropertyTermination();
    }

    public boolean supportsBacktrack() {
        return true;
    }
}

