/*
 * Decompiled with CFR 0.152.
 */
package checker.envgen;

import checker.envgen.EnvDescriptor;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.bpc.checker.node.AlternativeNode;
import org.objectweb.fractal.bpc.checker.node.AndParallelNode;
import org.objectweb.fractal.bpc.checker.node.EventNode;
import org.objectweb.fractal.bpc.checker.node.NullNode;
import org.objectweb.fractal.bpc.checker.node.RepetitionNode;
import org.objectweb.fractal.bpc.checker.node.SequenceNode;
import org.objectweb.fractal.bpc.checker.node.TreeNode;

public class CodeGenerator {
    private static final String DEF_MAIN_PKG = "test";
    private static final String ENV_VALUES_ATTR = "envValues";
    private static final String EVENT_LOCK = "eventLock";
    private static final String EVENT_FLAG = "eventFlag";

    public Map generate(EnvDescriptor envDesc) throws Exception {
        Map clientStubNames = this.computeClientStubNames(envDesc.clientItfs);
        LinkedList clientEventFlags = new LinkedList();
        for (Map.Entry entry : envDesc.clientItfs.entrySet()) {
            String cliItfName = (String)entry.getKey();
            String javaItfName = (String)entry.getValue();
            String stubClassName = (String)clientStubNames.get(cliItfName);
            List flags = this.generateClientStub(envDesc, cliItfName, javaItfName, stubClassName);
            clientEventFlags.addAll(flags);
        }
        this.generateServerStub(envDesc);
        this.generateMainClass(envDesc, clientStubNames, clientEventFlags);
        HashMap<String, String> itf2class = new HashMap<String, String>();
        itf2class.putAll(clientStubNames);
        for (String itfName : envDesc.serverItfs.keySet()) {
            itf2class.put(itfName, envDesc.contentClass);
        }
        return itf2class;
    }

    public String getMainClassName(String componentName) {
        String packageName = this.getPackageName(componentName);
        if (packageName == null || packageName.length() == 0) {
            packageName = DEF_MAIN_PKG;
        }
        return packageName + "." + this.getShortClassName(componentName) + "Main";
    }

    private List generateClientStub(EnvDescriptor envDesc, String cliItfName, String javaItfName, String stubClassName) throws Exception {
        LinkedList<String> eventFlags = new LinkedList<String>();
        String sourceFileName = this.getSourceFileName(envDesc.targetDir, stubClassName);
        this.makePackageDirs(sourceFileName);
        PrintWriter out = new PrintWriter(new FileWriter(sourceFileName));
        String packageName = this.getPackageName(stubClassName);
        if (packageName != null && packageName.length() > 0) {
            out.println("package " + packageName + ";");
            out.println();
        }
        out.println("import gov.nasa.jpf.jvm.Verify;");
        out.println();
        out.println("import checker.envgen.EnvValueSets;");
        out.println();
        String compPkgName = this.getPackageName(envDesc.componentName);
        if (compPkgName == null || compPkgName.length() == 0) {
            compPkgName = DEF_MAIN_PKG;
        }
        out.println("import " + compPkgName + ".*;");
        out.println();
        out.println();
        out.println("public class " + this.getShortClassName(stubClassName) + " implements " + javaItfName);
        out.println("{");
        this.printEnvValueAttribute(out, 1, stubClassName, envDesc.valueSetsClass);
        Class<?> javaItfClass = Thread.currentThread().getContextClassLoader().loadClass(javaItfName);
        Method[] itfMethods = javaItfClass.getMethods();
        for (int i = 0; i < itfMethods.length; ++i) {
            Method itfMethod = itfMethods[i];
            String retTypeName = itfMethod.getReturnType().getName();
            if (itfMethod.getReturnType().isArray()) {
                retTypeName = this.printArrayType(retTypeName);
            }
            out.print("\t");
            out.print("public ");
            out.print(retTypeName + " ");
            out.print(itfMethod.getName());
            Class<?>[] paramTypes = itfMethod.getParameterTypes();
            out.print("(");
            for (int j = 0; j < paramTypes.length; ++j) {
                Class<?> paramType = paramTypes[j];
                if (paramType.isArray()) {
                    out.print(this.printArrayType(paramType.getName()) + " arg" + j);
                } else {
                    out.print(paramType.getName() + " arg" + j);
                }
                if (j >= paramTypes.length - 1) continue;
                out.print(", ");
            }
            out.print(")");
            Class<?>[] exceptTypes = itfMethod.getExceptionTypes();
            if (exceptTypes.length > 0) {
                out.print(" throws ");
            }
            for (int j = 0; j < exceptTypes.length; ++j) {
                Class<?> exceptType = exceptTypes[j];
                out.print(exceptType.getName());
                if (j >= exceptTypes.length - 1) continue;
                out.print(", ");
            }
            out.println();
            out.println("\t{");
            String eventName = cliItfName + "." + itfMethod.getName();
            int eventIndex = this.getClientCallEventIndex(envDesc.protocolNode, eventName);
            if (eventIndex >= 0) {
                String lockName = this.getMainClassName(envDesc.componentName) + "." + EVENT_LOCK;
                String flagName = this.getMainClassName(envDesc.componentName) + "." + EVENT_FLAG + eventIndex;
                out.println("\t\tsynchronized(" + lockName + ")");
                out.println("\t\t{");
                out.println("\t\t\t" + flagName + " = true;");
                out.println("\t\t\t" + lockName + ".notifyAll();");
                out.println("\t\t}");
                eventFlags.add(EVENT_FLAG + eventIndex);
            }
            if (!retTypeName.equals("void")) {
                out.println("\t\treturn " + this.printValueSelection(envDesc.componentName, javaItfName, itfMethod.getName(), retTypeName) + ";");
            }
            out.println("\t}");
            out.println();
        }
        out.println("}");
        out.close();
        return eventFlags;
    }

    private String generateMainClass(EnvDescriptor envDesc, Map clientStubNames, List clientEventFlags) throws Exception {
        String packageName = this.getPackageName(envDesc.componentName);
        if (packageName == null || packageName.length() == 0) {
            packageName = DEF_MAIN_PKG;
        }
        String mainClassName = this.getMainClassName(envDesc.componentName);
        String sourceFileName = this.getSourceFileName(envDesc.targetDir, mainClassName);
        this.makePackageDirs(sourceFileName);
        PrintWriter out = new PrintWriter(new FileWriter(sourceFileName));
        out.println("package " + packageName + ";");
        out.println();
        out.println();
        out.println("public class " + this.getShortClassName(mainClassName));
        out.println("{");
        out.println("\tpublic static final String eventLock = \"EventLock\";");
        for (String string : clientEventFlags) {
            out.println("\tpublic static boolean " + string + " = false;");
        }
        out.println();
        out.println();
        out.println("\tpublic static void main(String[] args)");
        out.println("\t{");
        out.println("\t\ttry");
        out.println("\t\t{");
        out.println("\t\t\t" + envDesc.contentClass + " comp = new " + envDesc.contentClass + "();");
        out.println();
        out.println("\t\t\t" + envDesc.componentName + "Environment" + " env = new " + envDesc.componentName + "Environment" + "();");
        out.println();
        for (String string : envDesc.serverItfs.keySet()) {
            out.println("\t\t\tenv.set" + string + "(comp);");
        }
        for (Map.Entry entry : clientStubNames.entrySet()) {
            String cliItf = (String)entry.getKey();
            String stubClassName = (String)entry.getValue();
            out.println("\t\t\tcomp.set" + cliItf + "(new " + stubClassName + "());");
        }
        out.println();
        out.println("\t\t\tenv.run();");
        out.println("\t\t}");
        out.println("\t\tcatch (Exception e)");
        out.println("\t\t{");
        out.println("\t\t\te.printStackTrace();");
        out.println("\t\t}");
        out.println("\t}");
        out.println("}");
        out.close();
        return mainClassName;
    }

    private void generateServerStub(EnvDescriptor envDesc) throws Exception {
        String javaItfName;
        String srvItfName;
        String packageName = this.getPackageName(envDesc.componentName);
        if (packageName == null || packageName.length() == 0) {
            packageName = DEF_MAIN_PKG;
        }
        String envClassName = packageName + "." + this.getShortClassName(envDesc.componentName) + "Environment";
        String sourceFileName = this.getSourceFileName(envDesc.targetDir, envClassName);
        this.makePackageDirs(sourceFileName);
        PrintWriter out = new PrintWriter(new FileWriter(sourceFileName));
        out.println("package " + packageName + ";");
        out.println();
        out.println("import gov.nasa.jpf.jvm.Verify;");
        out.println();
        out.println("import checker.envgen.EnvValueSets;");
        out.println();
        out.println();
        out.println("public class " + this.getShortClassName(envClassName) + " implements Runnable");
        out.println("{");
        this.printEnvValueAttribute(out, 1, envClassName, envDesc.valueSetsClass);
        out.println();
        for (Map.Entry entry : envDesc.serverItfs.entrySet()) {
            srvItfName = (String)entry.getKey();
            javaItfName = (String)entry.getValue();
            out.println("\tprivate " + javaItfName + " " + srvItfName + " = null;");
        }
        out.println();
        for (Map.Entry entry : envDesc.serverItfs.entrySet()) {
            srvItfName = (String)entry.getKey();
            javaItfName = (String)entry.getValue();
            out.println("\tpublic void set" + srvItfName + "(Object obj)");
            out.println("\t{");
            out.println("\t\t" + srvItfName + " = (" + javaItfName + ") obj;");
            out.println("\t}");
            out.println();
        }
        out.println("\tpublic void run()");
        out.println("\t{");
        int varNum = 0;
        varNum = this.printProtocolNode(out, 2, varNum, envDesc.componentName, envDesc.protocolNode, envDesc.serverItfs);
        out.println("\t}");
        out.println("}");
        out.close();
    }

    private int printProtocolNode(PrintWriter out, int tabLevel, int varNum, String componentName, TreeNode tn, Map serverItfs) throws Exception {
        int newVarNum = varNum;
        if (tn instanceof EventNode) {
            if (this.isCallOnClientItf(tn, serverItfs)) {
                String lockName = this.getMainClassName(componentName) + "." + EVENT_LOCK;
                String flagName = this.getMainClassName(componentName) + "." + EVENT_FLAG + ((EventNode)tn).getEventIndex();
                String eventName = tn.protocol.substring(1, tn.protocol.length() - 1);
                this.printWaitForEventFlags(out, tabLevel, lockName, new String[]{flagName});
            } else if (tn.protocol.charAt(0) == '!' && tn.protocol.charAt(tn.protocol.length() - 1) == '^') {
                this.printServerCall(out, tabLevel, (EventNode)tn, serverItfs, componentName);
            }
        } else if (tn instanceof SequenceNode) {
            TreeNode[] children = tn.getChildren();
            for (int i = 0; i < children.length; ++i) {
                newVarNum = this.printProtocolNode(out, tabLevel, newVarNum, componentName, children[i], serverItfs);
            }
        } else if (tn instanceof AlternativeNode) {
            TreeNode[] children = tn.getChildren();
            this.printTabs(out, tabLevel);
            out.println("int i" + ++newVarNum + " = Verify.random(" + String.valueOf(children.length - 1) + ");");
            int ifVarNum = newVarNum;
            for (int i = 0; i < children.length; ++i) {
                this.printTabs(out, tabLevel);
                out.println("if (i" + ifVarNum + " == " + i + ")");
                this.printTabs(out, tabLevel);
                out.println("{");
                newVarNum = this.printProtocolNode(out, tabLevel + 1, newVarNum, componentName, children[i], serverItfs);
                this.printTabs(out, tabLevel);
                out.println("}");
            }
        } else if (tn instanceof RepetitionNode) {
            TreeNode[] children = tn.getChildren();
            this.printTabs(out, tabLevel);
            out.println("while (Verify.getBoolean())");
            this.printTabs(out, tabLevel);
            out.println("{");
            for (int i = 0; i < children.length; ++i) {
                newVarNum = this.printProtocolNode(out, tabLevel + 1, newVarNum, componentName, children[i], serverItfs);
            }
            this.printTabs(out, tabLevel);
            out.println("}");
        } else if (tn instanceof AndParallelNode) {
            int i;
            TreeNode[] children = tn.getChildren();
            int[] threadNums = new int[children.length];
            for (i = 0; i < children.length; ++i) {
                threadNums[i] = ++newVarNum;
                this.printTabs(out, tabLevel);
                out.println("class EnvThread" + threadNums[i] + " extends Thread");
                this.printTabs(out, tabLevel);
                out.println("{");
                this.printTabs(out, tabLevel + 1);
                out.println("boolean thFlag = false;");
                out.println("");
                this.printTabs(out, tabLevel + 1);
                out.println("public void run()");
                this.printTabs(out, tabLevel + 1);
                out.println("{");
                newVarNum = this.printProtocolNode(out, tabLevel + 2, newVarNum, componentName, children[i], serverItfs);
                this.printTabs(out, tabLevel + 2);
                out.println("synchronized (this) { thFlag = true; this.notify(); }");
                this.printTabs(out, tabLevel + 1);
                out.println("}");
                this.printTabs(out, tabLevel);
                out.println("};");
                out.println("EnvThread" + threadNums[i] + " th" + threadNums[i] + " = new EnvThread" + threadNums[i] + "();");
            }
            for (i = 0; i < threadNums.length; ++i) {
                this.printTabs(out, tabLevel);
                out.println("th" + threadNums[i] + ".start();");
            }
            this.printTabs(out, tabLevel);
            out.println("try");
            this.printTabs(out, tabLevel);
            out.println("{");
            for (i = 0; i < threadNums.length; ++i) {
                this.printTabs(out, tabLevel + 1);
                out.println("synchronized (th" + threadNums[i] + ") { while (!th" + threadNums[i] + ".thFlag) { th" + threadNums[i] + ".wait(); }}");
            }
            this.printTabs(out, tabLevel);
            out.println("}");
            this.printTabs(out, tabLevel);
            out.println("catch (InterruptedException ex) {}");
        }
        return newVarNum;
    }

    private void printServerCall(PrintWriter out, int tabLevel, EventNode en, Map serverItfs, String componentName) throws Exception {
        String event = en.protocol;
        int k = event.indexOf(46);
        String srvItfName = event.substring(1, k);
        String methodName = event.substring(k + 1, event.length() - 1);
        String javaItfName = (String)serverItfs.get(srvItfName);
        Class<?> javaItfClass = Thread.currentThread().getContextClassLoader().loadClass(javaItfName);
        this.printTabs(out, tabLevel);
        out.println("try");
        this.printTabs(out, tabLevel);
        out.println("{");
        Method[] itfMethods = javaItfClass.getMethods();
        for (int i = 0; i < itfMethods.length; ++i) {
            Method itfMethod = itfMethods[i];
            if (!itfMethod.getName().equals(methodName)) continue;
            this.printTabs(out, tabLevel + 1);
            out.print(srvItfName + "." + methodName);
            Class<?>[] paramTypes = itfMethod.getParameterTypes();
            out.print("(");
            for (int j = 0; j < paramTypes.length; ++j) {
                Class<?> paramType = paramTypes[j];
                String paramTypeName = paramType.getName();
                if (paramType.isArray()) {
                    paramTypeName = this.printArrayType(paramTypeName);
                }
                if (!paramTypeName.equals("void")) {
                    out.print(this.printValueSelection(componentName, javaItfName, itfMethod.getName(), paramTypeName));
                }
                if (j >= paramTypes.length - 1) continue;
                out.print(", ");
            }
            out.println(");");
        }
        this.printTabs(out, tabLevel);
        out.println("}");
        this.printTabs(out, tabLevel);
        out.println("catch (Exception ex) { ex.printStackTrace(); }");
    }

    private void printWaitForEventFlags(PrintWriter out, int tabLevel, String lockName, String[] flagNames) {
        if (lockName == null || flagNames == null) {
            return;
        }
        this.printTabs(out, tabLevel);
        out.println("synchronized(" + lockName + ")");
        this.printTabs(out, tabLevel);
        out.println("{");
        boolean flagsEmpty = true;
        for (int i = 0; i < flagNames.length; ++i) {
            if (flagNames[i].equals("")) continue;
            flagsEmpty = false;
        }
        if (!flagsEmpty && flagNames.length > 0) {
            int i;
            this.printTabs(out, tabLevel + 1);
            out.print("while (");
            boolean first = true;
            for (i = 0; i < flagNames.length; ++i) {
                if (flagNames[i].equals("")) continue;
                if (first) {
                    first = false;
                } else {
                    out.print(" && ");
                }
                out.print("(!" + flagNames[i] + ")");
            }
            out.println(")");
            this.printTabs(out, tabLevel + 1);
            out.println("{");
            this.printTabs(out, tabLevel + 2);
            out.println("try { " + lockName + ".wait(); } catch (InterruptedException ex) {}");
            this.printTabs(out, tabLevel + 1);
            out.println("}");
            for (i = 0; i < flagNames.length; ++i) {
                if (flagNames[i].equals("")) continue;
                this.printTabs(out, tabLevel + 1);
                out.println(flagNames[i] + " = false;");
            }
        }
        this.printTabs(out, tabLevel);
        out.println("}");
    }

    private void printEnvValueAttribute(PrintWriter out, int tabLevel, String stubClassName, String valueSetsClass) {
        this.printTabs(out, tabLevel);
        out.println("private EnvValueSets envValues;");
        out.println();
        this.printTabs(out, tabLevel);
        out.println("public " + this.getShortClassName(stubClassName) + "()");
        this.printTabs(out, tabLevel);
        out.println("{");
        this.printTabs(out, tabLevel + 1);
        out.println("try");
        this.printTabs(out, tabLevel + 1);
        out.println("{");
        this.printTabs(out, tabLevel + 2);
        out.println("envValues = new " + valueSetsClass + "();");
        this.printTabs(out, tabLevel + 1);
        out.println("}");
        this.printTabs(out, tabLevel + 1);
        out.println("catch (Exception ex)");
        this.printTabs(out, tabLevel + 1);
        out.println("{");
        this.printTabs(out, tabLevel + 2);
        out.println("ex.printStackTrace();");
        this.printTabs(out, tabLevel + 2);
        out.println("envValues = null;");
        this.printTabs(out, tabLevel + 1);
        out.println("}");
        this.printTabs(out, tabLevel);
        out.println("}");
        out.println();
    }

    private int printDriverAndWaitForEventFlags(PrintWriter out, int tabLevel, int varNum, String driversCode, String lockName, String[] flagNames) {
        int newVarNum = varNum;
        this.printTabs(out, tabLevel);
        out.println("Thread th" + ++newVarNum + " = new Thread()");
        int threadNum1 = newVarNum++;
        this.printTabs(out, tabLevel);
        out.println("{");
        this.printTabs(out, tabLevel + 1);
        out.println("public void run()");
        this.printTabs(out, tabLevel + 1);
        out.println("{");
        out.print(driversCode);
        this.printTabs(out, tabLevel + 1);
        out.println("}");
        this.printTabs(out, tabLevel);
        out.println("};");
        this.printTabs(out, tabLevel);
        out.println("Thread th" + newVarNum + " = new Thread()");
        int threadNum2 = newVarNum;
        this.printTabs(out, tabLevel);
        out.println("{");
        this.printTabs(out, tabLevel + 1);
        out.println("public void run()");
        this.printTabs(out, tabLevel + 1);
        out.println("{");
        this.printWaitForEventFlags(out, tabLevel, lockName, flagNames);
        this.printTabs(out, tabLevel + 1);
        out.println("}");
        this.printTabs(out, tabLevel);
        out.println("};");
        this.printTabs(out, tabLevel);
        out.println("th" + threadNum1 + ".start();");
        this.printTabs(out, tabLevel);
        out.println("th" + threadNum2 + ".start();");
        this.printTabs(out, tabLevel);
        out.println("try");
        this.printTabs(out, tabLevel);
        out.println("{");
        this.printTabs(out, tabLevel + 1);
        out.println("th" + threadNum1 + ".join();");
        this.printTabs(out, tabLevel + 1);
        out.println("th" + threadNum2 + ".join();");
        this.printTabs(out, tabLevel);
        out.println("}");
        this.printTabs(out, tabLevel);
        out.println("catch (InterruptedException ex) {}");
        return newVarNum;
    }

    private String printValueSelection(String componentName, String javaItfName, String methodName, String typeName) {
        if (typeName.equals("boolean")) {
            return "envValues.getBoolean(\"" + componentName + "\", \"" + javaItfName + "\", \"" + methodName + "\")";
        }
        if (typeName.equals("byte")) {
            return "envValues.getByte(\"" + componentName + "\", \"" + javaItfName + "\", \"" + methodName + "\")";
        }
        if (typeName.equals("short")) {
            return "envValues.getShort(\"" + componentName + "\", \"" + javaItfName + "\", \"" + methodName + "\")";
        }
        if (typeName.equals("int")) {
            return "envValues.getInt(\"" + componentName + "\", \"" + javaItfName + "\", \"" + methodName + "\")";
        }
        if (typeName.equals("long")) {
            return "envValues.getLong(\"" + componentName + "\", \"" + javaItfName + "\", \"" + methodName + "\")";
        }
        if (typeName.equals("char")) {
            return "envValues.getChar(\"" + componentName + "\", \"" + javaItfName + "\", \"" + methodName + "\")";
        }
        if (typeName.equals("float")) {
            return "envValues.getFloat(\"" + componentName + "\", \"" + javaItfName + "\", \"" + methodName + "\")";
        }
        if (typeName.equals("double")) {
            return "envValues.getDouble(\"" + componentName + "\", \"" + javaItfName + "\", \"" + methodName + "\")";
        }
        if (typeName.equals("java.lang.String")) {
            return "envValues.getString(\"" + componentName + "\", \"" + javaItfName + "\", \"" + methodName + "\")";
        }
        if (!typeName.equals("void")) {
            return "(" + typeName + ") " + ENV_VALUES_ATTR + ".getObject(\"" + typeName + "\", \"" + componentName + "\", \"" + javaItfName + "\", \"" + methodName + "\")";
        }
        return "";
    }

    private Map computeClientStubNames(Map clientItfs) {
        HashMap<String, String> stubNames = new HashMap<String, String>();
        HashMap<String, Integer> stubCounts = new HashMap<String, Integer>();
        for (Map.Entry entry : clientItfs.entrySet()) {
            String cliItfName = (String)entry.getKey();
            String javaItfName = (String)entry.getValue();
            Integer count = (Integer)stubCounts.get(javaItfName);
            count = count == null ? new Integer(1) : new Integer(count + 1);
            String stubClassName = javaItfName + "Stub" + "_" + count.toString();
            stubCounts.put(javaItfName, count);
            stubNames.put(cliItfName, stubClassName);
        }
        return stubNames;
    }

    private boolean isCallOnClientItf(TreeNode tn, Map serverItfs) {
        if (!(tn instanceof EventNode)) {
            return false;
        }
        EventNode evtn = (EventNode)tn;
        int k = evtn.protocol.indexOf(46);
        String itf = evtn.protocol.substring(1, k);
        if (evtn.protocol.startsWith("!") || evtn.protocol.endsWith("$")) {
            return false;
        }
        return !serverItfs.containsKey(itf);
    }

    private boolean callsOnlyOnClientItfs(TreeNode tn, Map serverItfs) {
        if (tn instanceof NullNode) {
            return true;
        }
        if (tn instanceof EventNode) {
            if (tn.protocol.endsWith("$")) {
                return true;
            }
            return this.isCallOnClientItf(tn, serverItfs);
        }
        TreeNode[] children = tn.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (this.callsOnlyOnClientItfs(children[i], serverItfs)) continue;
            return false;
        }
        return true;
    }

    private int getClientCallEventIndex(TreeNode tn, String eventName) {
        if (tn instanceof NullNode) {
            return -1;
        }
        if (tn instanceof EventNode) {
            EventNode evtn = (EventNode)tn;
            if (evtn.protocol.equals("?" + eventName + "^")) {
                return evtn.getEventIndex();
            }
            return -1;
        }
        TreeNode[] children = tn.getChildren();
        for (int i = 0; i < children.length; ++i) {
            int evIdx = this.getClientCallEventIndex(children[i], eventName);
            if (evIdx < 0) continue;
            return evIdx;
        }
        return -1;
    }

    private String getPackageName(String className) {
        String packageName = "";
        int k = className.lastIndexOf(46);
        if (k != -1) {
            packageName = className.substring(0, k);
        }
        return packageName;
    }

    private String getShortClassName(String fullClassName) {
        int k = fullClassName.lastIndexOf(46);
        if (k == -1) {
            return fullClassName;
        }
        return fullClassName.substring(k + 1);
    }

    private String getSourceFileName(String targetDir, String className) {
        return targetDir + File.separator + className.replace('.', File.separatorChar) + ".java";
    }

    private void makePackageDirs(String sourceFileName) throws Exception {
        if (sourceFileName == null) {
            return;
        }
        if (sourceFileName.length() == 0) {
            return;
        }
        int k = sourceFileName.lastIndexOf(File.separatorChar);
        if (k == -1) {
            return;
        }
        String sourceDir = sourceFileName.substring(0, k);
        File sd = new File(sourceDir);
        if (sd.exists() && sd.isDirectory()) {
            return;
        }
        sd.mkdirs();
    }

    private String printArrayType(String internalTypeName) {
        int arrayDim = 0;
        int pos = 0;
        String typeName = "";
        while (internalTypeName.charAt(pos) == '[') {
            ++arrayDim;
            ++pos;
        }
        if (internalTypeName.charAt(pos) == 'L') {
            typeName = internalTypeName.substring(++pos, internalTypeName.length() - 1);
        } else if (internalTypeName.charAt(pos) == 'Z') {
            typeName = "boolean";
        } else if (internalTypeName.charAt(pos) == 'B') {
            typeName = "byte";
        } else if (internalTypeName.charAt(pos) == 'C') {
            typeName = "char";
        } else if (internalTypeName.charAt(pos) == 'D') {
            typeName = "double";
        } else if (internalTypeName.charAt(pos) == 'F') {
            typeName = "float";
        } else if (internalTypeName.charAt(pos) == 'I') {
            typeName = "int";
        } else if (internalTypeName.charAt(pos) == 'J') {
            typeName = "long";
        } else if (internalTypeName.charAt(pos) == 'S') {
            typeName = "short";
        }
        for (int i = 0; i < arrayDim; ++i) {
            typeName = typeName + "[]";
        }
        return typeName;
    }

    private void printTabs(PrintWriter out, int tabCount) {
        for (int i = 0; i < tabCount; ++i) {
            out.print("\t");
        }
    }
}

