/*
 * Decompiled with CFR 0.152.
 */
package checker;

import checker.envgen.CodeGenerator;
import checker.envgen.EnvDescriptor;
import checker.jpfbpc.JPFCheckerSearch;
import checker.jpfbpc.ProtocolListener;
import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.PropertyListenerAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.objectweb.fractal.bpc.checker.JPFStaticChecker;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.AlternativeNode;
import org.objectweb.fractal.bpc.checker.node.AndParallelNode;
import org.objectweb.fractal.bpc.checker.node.EventNode;
import org.objectweb.fractal.bpc.checker.node.NullNode;
import org.objectweb.fractal.bpc.checker.node.RepetitionNode;
import org.objectweb.fractal.bpc.checker.node.SequenceNode;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.parser.Builder;
import org.objectweb.fractal.bpc.checker.parser.ProtocolReader;
import org.objectweb.fractal.bpc.checker.parser.StringTokenizer;

public class Main {
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: java checker.Main <property file with component definition> <protocol file> <temporary directory> <classpath for JPF model classes>");
            return;
        }
        EnvDescriptor envDesc = Main.loadEnvDesc(args[0], System.out);
        String protocolFile = args[1];
        envDesc.targetDir = args[2];
        Main.runTool(envDesc, protocolFile, args[3], System.out);
    }

    public static void runFromEclipse(String componentName, String componentImpl, Map<String, String> provItfs, Map<String, String> reqItfs, File protocolFile, String valueSetsClassName, File tmpDir, Collection<File> pathsToJPFModelClasses, OutputStream out) {
        EnvDescriptor envDesc = new EnvDescriptor();
        envDesc.componentName = componentName;
        envDesc.contentClass = componentImpl;
        envDesc.serverItfs = new HashMap();
        envDesc.serverItfs.putAll(provItfs);
        envDesc.clientItfs = new HashMap();
        envDesc.clientItfs.putAll(reqItfs);
        String protocolFilePath = protocolFile.getAbsolutePath();
        envDesc.valueSetsClass = valueSetsClassName;
        envDesc.targetDir = tmpDir.getAbsolutePath();
        StringBuffer strBuf = new StringBuffer();
        boolean first = true;
        for (File f : pathsToJPFModelClasses) {
            if (first) {
                first = false;
            } else {
                strBuf.append(",");
            }
            strBuf.append(f.getAbsolutePath());
        }
        String classpathForJPFModelClasses = strBuf.toString();
        Main.runTool(envDesc, protocolFilePath, classpathForJPFModelClasses, new PrintStream(out));
    }

    public static void runTool(EnvDescriptor envDesc, String protocolFile, String classpathForJPFModelClasses, PrintStream out) {
        String[] frameEvents;
        Map itf2class;
        String frameProtoStr = Main.loadFileContents(protocolFile);
        TreeNode frameProto = Main.parseProtocol(frameProtoStr, out);
        String invframeProtoStr = Main.invertProtocol(frameProtoStr);
        TreeNode invframeProto = Main.parseProtocol(invframeProtoStr, out);
        envDesc.protocolNode = Main.removeEventsOnClientItfs(invframeProto, envDesc.serverItfs.keySet(), envDesc.clientItfs.keySet(), new HashSet());
        envDesc.protocolStr = envDesc.protocolNode.protocol;
        out.println("Checking component " + envDesc.componentName);
        CodeGenerator codeGen = new CodeGenerator();
        String mainClassName = codeGen.getMainClassName(envDesc.componentName);
        try {
            itf2class = codeGen.generate(envDesc);
        }
        catch (Exception ex) {
            out.println("\tFailed to generate environment classes");
            ex.printStackTrace();
            return;
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        String[] javaFileNames = new String[]{envDesc.targetDir + File.separator + mainClassName.replace('.', File.separatorChar) + ".java"};
        Iterable<? extends JavaFileObject> javaFiles = fileManager.getJavaFileObjectsFromStrings(Arrays.asList(javaFileNames));
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(envDesc.targetDir);
        options.add("-sourcepath");
        options.add(envDesc.targetDir);
        options.add("-cp");
        options.add(System.getProperty("java.class.path"));
        Boolean compileResult = compiler.getTask(null, fileManager, null, options, null, javaFiles).call();
        if (!compileResult.booleanValue()) {
            out.println("\tFailed the compile the environment classes");
            return;
        }
        try {
            frameEvents = JPFStaticChecker.getEvents((String)frameProtoStr);
        }
        catch (Exception ex) {
            out.println("\tFailed to extract protocol events");
            ex.printStackTrace();
            return;
        }
        try {
            boolean res = Main.runJPF(classpathForJPFModelClasses, mainClassName, frameProtoStr, itf2class, envDesc.serverItfs.keySet(), frameEvents, out);
            out.println("Result: " + (res ? "OK" : "ERROR"));
        }
        catch (Exception ex) {
            out.println("\tFailed to run JPF correctly");
            ex.printStackTrace();
            return;
        }
    }

    public static boolean runJPF(String classpathForModelClasses, String mainClass, String protocol, Map itf2class, Set serverItfs, String[] frameEvents, PrintStream out) throws Exception {
        ArrayList<String> cfgParams = new ArrayList<String>();
        cfgParams.add("+search.class=checker.jpfbpc.JPFCheckerSearch");
        cfgParams.add("+jpf.report.publisher=console");
        cfgParams.add("+jpf.report.console.class=gov.nasa.jpf.report.ConsolePublisher");
        cfgParams.add("+jpf.report.console.start=jpf,sut");
        cfgParams.add("+jpf.report.console.property_violation=error,trace,snapshot");
        cfgParams.add("+jpf.report.console.finished=result,statistics");
        cfgParams.add("+jpf.report.console.show_cg=true");
        cfgParams.add("+jpf.report.console.show_steps=true");
        cfgParams.add("+jpf.report.console.show_location=true");
        cfgParams.add("+jpf.report.console.show_source=true");
        cfgParams.add("+jpf.report.console.show_method=true");
        cfgParams.add("+jpf.report.console.show_code=false");
        cfgParams.add("+vm.bootclasspath=" + classpathForModelClasses);
        cfgParams.add(mainClass);
        Config cfg = JPF.createConfig((String[])cfgParams.toArray(new String[0]));
        JPF jpf = new JPF(cfg);
        JPFStaticChecker checker = new JPFStaticChecker(protocol, true, out);
        ProtocolListener pl = new ProtocolListener(checker.getNotifee(), itf2class, serverItfs, frameEvents);
        jpf.addPropertyListener((PropertyListenerAdapter)pl);
        ((JPFCheckerSearch)jpf.getSearch()).setJPFTraverser(checker.getNotifee());
        jpf.run();
        return !jpf.foundErrors();
    }

    public static TreeNode parseProtocol(String protocol, PrintStream out) {
        try {
            StringTokenizer st = new StringTokenizer(protocol);
            ActionRepository ar = new ActionRepository();
            Builder b = new Builder(ar);
            return b.build((ProtocolReader)st, false);
        }
        catch (Exception ex) {
            out.println("\tFailed to parse the component's frame protocol: " + ex.getMessage());
            return null;
        }
    }

    public static String invertProtocol(String protocol) {
        String s1 = protocol.replace('!', '@');
        String s2 = s1.replace('?', '!');
        return s2.replace('@', '?');
    }

    public static TreeNode removeEventsOnClientItfs(TreeNode tn, Set serverItfs, Set clientItfs, Set triggerEvents) {
        if (tn instanceof NullNode) {
            return tn;
        }
        if (tn instanceof EventNode) {
            if (Main.isEventOnItfFromSet(tn, serverItfs)) {
                return tn;
            }
            if (Main.isEventOnItfFromSet(tn, clientItfs)) {
                if (Main.isEventInSet(tn, triggerEvents)) {
                    return tn;
                }
                return new NullNode();
            }
            return new NullNode();
        }
        TreeNode[] oldChildren = tn.getChildren();
        ArrayList<Object> newChildren = new ArrayList<Object>();
        for (int i = 0; i < oldChildren.length; ++i) {
            TreeNode child = Main.removeEventsOnClientItfs(oldChildren[i], serverItfs, clientItfs, triggerEvents);
            if (child instanceof EventNode) {
                newChildren.add(child);
                continue;
            }
            if (child instanceof NullNode) {
                newChildren.add(child);
                continue;
            }
            if (child instanceof AlternativeNode || child instanceof AndParallelNode || child instanceof SequenceNode) {
                if (child.getChildren().length >= 2) {
                    newChildren.add(child);
                    continue;
                }
                if (child.getChildren().length != 1) continue;
                TreeNode grandChild = child.getChildren()[0];
                newChildren.add(grandChild);
                continue;
            }
            if (!(child instanceof RepetitionNode)) continue;
            if (child.getChildren().length >= 1) {
                newChildren.add(child);
                continue;
            }
            newChildren.add(new NullNode());
        }
        if (newChildren.isEmpty()) {
            return new NullNode();
        }
        if (tn instanceof AlternativeNode) {
            if (newChildren.size() >= 2) {
                return new AlternativeNode(newChildren.toArray(new TreeNode[newChildren.size()]));
            }
            if (newChildren.size() == 1) {
                return (TreeNode)newChildren.get(0);
            }
        } else if (tn instanceof AndParallelNode) {
            if (newChildren.size() >= 2) {
                return new AndParallelNode(newChildren.toArray(new TreeNode[newChildren.size()]));
            }
            if (newChildren.size() == 1) {
                return (TreeNode)newChildren.get(0);
            }
        } else if (tn instanceof SequenceNode) {
            if (newChildren.size() >= 2) {
                return new SequenceNode(newChildren.toArray(new TreeNode[newChildren.size()]));
            }
            if (newChildren.size() == 1) {
                return (TreeNode)newChildren.get(0);
            }
        } else if (tn instanceof RepetitionNode && newChildren.size() >= 1) {
            return new RepetitionNode((TreeNode)newChildren.get(0));
        }
        return new NullNode();
    }

    public static boolean isEventOnItfFromSet(TreeNode tn, Set itfSet) {
        if (!(tn instanceof EventNode)) {
            return false;
        }
        EventNode evtn = (EventNode)tn;
        int k = evtn.protocol.indexOf(46);
        String itf = evtn.protocol.substring(1, k);
        return itfSet.contains(itf);
    }

    public static boolean isEventInSet(TreeNode tn, Set eventSet) {
        if (!(tn instanceof EventNode)) {
            return false;
        }
        EventNode evtn = (EventNode)tn;
        String eventName = evtn.protocol.substring(1, evtn.protocol.length() - 1);
        return eventSet.contains(eventName);
    }

    public static EnvDescriptor loadEnvDesc(String propFileName, PrintStream out) {
        Properties props = Main.loadPropertiesFromFile(propFileName, out);
        EnvDescriptor envDesc = new EnvDescriptor();
        envDesc.componentName = props.getProperty("component.name").trim();
        envDesc.contentClass = props.getProperty("component.content").trim();
        envDesc.serverItfs = new HashMap();
        String serverItfsStr = props.getProperty("component.serveritfs").trim();
        String[] serverItfsAr = serverItfsStr.split(";");
        for (int i = 0; i < serverItfsAr.length; ++i) {
            if (!serverItfsAr[i].contains("-")) continue;
            String[] serverItf = serverItfsAr[i].split("-");
            envDesc.serverItfs.put(serverItf[0].trim(), serverItf[1].trim());
        }
        envDesc.clientItfs = new HashMap();
        String clientItfsStr = props.getProperty("component.clientitfs").trim();
        String[] clientItfsAr = clientItfsStr.split(";");
        for (int i = 0; i < clientItfsAr.length; ++i) {
            if (!clientItfsAr[i].contains("-")) continue;
            String[] clientItf = clientItfsAr[i].split("-");
            envDesc.clientItfs.put(clientItf[0].trim(), clientItf[1].trim());
        }
        envDesc.valueSetsClass = props.getProperty("env.valuesets").trim();
        return envDesc;
    }

    public static Properties loadPropertiesFromFile(String propFileName, PrintStream out) {
        Properties props = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(propFileName);
        }
        catch (IOException ex) {
            out.println("ERROR in Main: failed to open file '" + propFileName + "'");
            return null;
        }
        try {
            props.load(input);
        }
        catch (IOException ex) {
            out.println("ERROR in Main: failed to load properties from file '" + propFileName + "'");
            try {
                ((InputStream)input).close();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return null;
        }
        try {
            ((InputStream)input).close();
        }
        catch (IOException ex) {
            out.println("ERROR in Main: failed to close file '" + propFileName + "'");
            return null;
        }
        return props;
    }

    private static String loadFileContents(String classpathFile) {
        if (classpathFile == null) {
            return null;
        }
        String content = null;
        try {
            FileInputStream is = new FileInputStream(classpathFile);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            content = "";
            String line = in.readLine();
            while (line != null) {
                content = content + line;
                content = content + "\n";
                line = in.readLine();
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            content = null;
        }
        return content;
    }
}

