/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.AbstractSubscription;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.policy.MessageEvictionStrategy;
import org.apache.activemq.broker.region.policy.OldestMessageEvictionStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.Response;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TopicSubscription
extends AbstractSubscription {
    private static final Log log = LogFactory.getLog((Class)TopicSubscription.class);
    protected final LinkedList matched = new LinkedList();
    protected final ActiveMQDestination dlqDestination = new ActiveMQQueue("ActiveMQ.DLQ");
    protected final UsageManager usageManager;
    protected AtomicLong dispatched = new AtomicLong();
    protected AtomicLong delivered = new AtomicLong();
    private int maximumPendingMessages = -1;
    private MessageEvictionStrategy messageEvictionStrategy = new OldestMessageEvictionStrategy();
    private int discarded = 0;
    private final Object matchedListMutex = new Object();
    private final AtomicLong enqueueCounter = new AtomicLong(0L);
    private final AtomicLong dequeueCounter = new AtomicLong(0L);
    boolean singleDestination = true;
    Destination destination;

    public TopicSubscription(Broker broker, ConnectionContext context, ConsumerInfo info, UsageManager usageManager) throws InvalidSelectorException {
        super(broker, context, info);
        this.usageManager = usageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MessageReference node) throws InterruptedException, IOException {
        this.enqueueCounter.incrementAndGet();
        node.incrementReferenceCount();
        if (!this.isFull() && !this.isSlaveBroker()) {
            this.optimizePrefetch();
            this.dispatch(node);
        } else if (this.maximumPendingMessages != 0) {
            Object object = this.matchedListMutex;
            synchronized (object) {
                this.matched.addLast(node);
                if (this.maximumPendingMessages > 0) {
                    int max = this.messageEvictionStrategy.getEvictExpiredMessagesHighWatermark();
                    if (this.maximumPendingMessages > 0 && this.maximumPendingMessages < max) {
                        max = this.maximumPendingMessages;
                    }
                    if (!this.matched.isEmpty() && this.matched.size() > max) {
                        this.removeExpiredMessages(this.matched);
                    }
                    while (!this.matched.isEmpty() && this.matched.size() > this.maximumPendingMessages) {
                        MessageReference[] oldMessages = this.messageEvictionStrategy.evictMessages(this.matched);
                        int messagesToEvict = oldMessages.length;
                        for (int i = 0; i < messagesToEvict; ++i) {
                            oldMessages[i].decrementReferenceCount();
                            ++this.discarded;
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Discarding message " + oldMessages[i]));
                        }
                        if (messagesToEvict != 0) continue;
                        log.warn((Object)("No messages to evict returned from eviction strategy: " + this.messageEvictionStrategy));
                        break;
                    }
                }
            }
        }
    }

    protected void removeExpiredMessages(LinkedList messages) throws IOException {
        Iterator i = this.matched.iterator();
        while (i.hasNext()) {
            MessageReference node = (MessageReference)i.next();
            if (!node.isExpired()) continue;
            i.remove();
            this.dispatched.incrementAndGet();
            node.decrementReferenceCount();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessageDispatchNotification(MessageDispatchNotification mdn) {
        Object object = this.matchedListMutex;
        synchronized (object) {
            Iterator i = this.matched.iterator();
            while (i.hasNext()) {
                MessageReference node = (MessageReference)i.next();
                if (!node.getMessageId().equals(mdn.getMessageId())) continue;
                i.remove();
                this.dispatched.incrementAndGet();
                node.decrementReferenceCount();
                break;
            }
        }
    }

    public synchronized void acknowledge(ConnectionContext context, final MessageAck ack) throws Exception {
        boolean wasFull = this.isFull();
        if (ack.isStandardAck() || ack.isPoisonAck()) {
            if (context.isInTransaction()) {
                this.delivered.addAndGet((long)ack.getMessageCount());
                context.getTransaction().addSynchronization(new Synchronization(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void afterCommit() throws Exception {
                        TopicSubscription topicSubscription = TopicSubscription.this;
                        synchronized (topicSubscription) {
                            if (TopicSubscription.this.singleDestination) {
                                TopicSubscription.this.destination.getDestinationStatistics().getDequeues().add(ack.getMessageCount());
                            }
                        }
                        TopicSubscription.this.dequeueCounter.addAndGet((long)ack.getMessageCount());
                        TopicSubscription.this.dispatched.addAndGet((long)(-ack.getMessageCount()));
                        TopicSubscription.this.delivered.set(Math.max(0L, TopicSubscription.this.delivered.get() - (long)ack.getMessageCount()));
                    }
                });
            } else {
                if (this.singleDestination) {
                    this.destination.getDestinationStatistics().getDequeues().add(ack.getMessageCount());
                }
                this.dequeueCounter.addAndGet((long)ack.getMessageCount());
                this.dispatched.addAndGet((long)(-ack.getMessageCount()));
                this.delivered.set(Math.max(0L, this.delivered.get() - (long)ack.getMessageCount()));
            }
            if (wasFull && !this.isFull()) {
                this.dispatchMatched();
            }
            return;
        }
        if (ack.isDeliveredAck()) {
            this.delivered.addAndGet((long)ack.getMessageCount());
            if (wasFull && !this.isFull()) {
                this.dispatchMatched();
            }
            return;
        }
        throw new JMSException("Invalid acknowledgment: " + ack);
    }

    public Response pullMessage(ConnectionContext context, MessagePull pull) throws Exception {
        return null;
    }

    public int getPendingQueueSize() {
        return this.matched();
    }

    public int getDispatchedQueueSize() {
        return (int)(this.dispatched.get() - this.delivered.get());
    }

    public int getMaximumPendingMessages() {
        return this.maximumPendingMessages;
    }

    public long getDispatchedCounter() {
        return this.dispatched.get();
    }

    public long getEnqueueCounter() {
        return this.enqueueCounter.get();
    }

    public long getDequeueCounter() {
        return this.dequeueCounter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int discarded() {
        Object object = this.matchedListMutex;
        synchronized (object) {
            return this.discarded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int matched() {
        Object object = this.matchedListMutex;
        synchronized (object) {
            return this.matched.size();
        }
    }

    public void setMaximumPendingMessages(int maximumPendingMessages) {
        this.maximumPendingMessages = maximumPendingMessages;
    }

    public MessageEvictionStrategy getMessageEvictionStrategy() {
        return this.messageEvictionStrategy;
    }

    public void setMessageEvictionStrategy(MessageEvictionStrategy messageEvictionStrategy) {
        this.messageEvictionStrategy = messageEvictionStrategy;
    }

    private boolean isFull() {
        return this.dispatched.get() - this.delivered.get() >= (long)this.info.getPrefetchSize();
    }

    public boolean isLowWaterMark() {
        return (double)(this.dispatched.get() - this.delivered.get()) <= (double)this.info.getPrefetchSize() * 0.4;
    }

    public boolean isHighWaterMark() {
        return (double)(this.dispatched.get() - this.delivered.get()) >= (double)this.info.getPrefetchSize() * 0.9;
    }

    public void updateConsumerPrefetch(int newPrefetch) {
        if (this.context != null && this.context.getConnection() != null && this.context.getConnection().isManageable()) {
            ConsumerControl cc = new ConsumerControl();
            cc.setConsumerId(this.info.getConsumerId());
            cc.setPrefetch(newPrefetch);
            this.context.getConnection().dispatchAsync(cc);
        }
    }

    public void optimizePrefetch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMatched() throws IOException {
        Object object = this.matchedListMutex;
        synchronized (object) {
            Iterator iter = this.matched.iterator();
            while (iter.hasNext() && !this.isFull()) {
                MessageReference message = (MessageReference)iter.next();
                iter.remove();
                this.dispatch(message);
            }
        }
    }

    private void dispatch(final MessageReference node) throws IOException {
        Message message = (Message)node;
        MessageDispatch md = new MessageDispatch();
        md.setMessage(message);
        md.setConsumerId(this.info.getConsumerId());
        md.setDestination(node.getRegionDestination().getActiveMQDestination());
        this.dispatched.incrementAndGet();
        if (this.singleDestination) {
            if (this.destination == null) {
                this.destination = node.getRegionDestination();
            } else if (this.destination != node.getRegionDestination()) {
                this.singleDestination = false;
            }
        }
        if (this.info.isDispatchAsync()) {
            md.setConsumer(new Runnable(){

                public void run() {
                    node.getRegionDestination().getDestinationStatistics().getDispatched().increment();
                    node.decrementReferenceCount();
                }
            });
            this.context.getConnection().dispatchAsync(md);
        } else {
            this.context.getConnection().dispatchSync(md);
            node.getRegionDestination().getDestinationStatistics().getDispatched().increment();
            node.decrementReferenceCount();
        }
    }

    public String toString() {
        return "TopicSubscription: consumer=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", dispatched=" + this.getDispatchedQueueSize() + ", delivered=" + this.getDequeueCounter() + ", matched=" + this.matched() + ", discarded=" + this.discarded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.matchedListMutex;
        synchronized (object) {
            Iterator iter = this.matched.iterator();
            while (iter.hasNext()) {
                MessageReference node = (MessageReference)iter.next();
                node.decrementReferenceCount();
            }
            this.matched.clear();
        }
    }
}

