/*
 * Decompiled with CFR 0.152.
 */
package org.somox.ui.runconfig.tabs;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Text;

public class WorkspaceButtonSelectionListener
extends SelectionAdapter {
    private Text field;
    private boolean selectDirectories = false;
    private boolean selectProjects = false;
    private boolean showRelativePath = false;

    public WorkspaceButtonSelectionListener(Text field, boolean selectDirectories, boolean selectProjects, boolean showRelativePath) {
        this.field = field;
        this.selectDirectories = selectDirectories;
        this.selectProjects = selectProjects;
        this.showRelativePath = showRelativePath;
    }

    public void widgetSelected(SelectionEvent e) {
        String resultOpenFileDialog;
        block12: {
            resultOpenFileDialog = "";
            if (this.selectDirectories) {
                String msg = "Select a folder.";
                IContainer dir = null;
                ArrayList<1> filters = new ArrayList<1>();
                if (this.selectProjects) {
                    filters.add(new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            return element instanceof IProject;
                        }
                    });
                }
                IContainer[] dirs = WorkspaceResourceDialog.openFolderSelection(null, null, (String)msg, (boolean)false, null, filters);
                try {
                    if (dirs.length != 0) {
                        dir = dirs[0];
                    }
                    if (dir == null) break block12;
                    if (this.showRelativePath) {
                        resultOpenFileDialog = this.selectProjects ? dir.getFullPath().toOSString().substring(1) : dir.getFullPath().toOSString().substring(1);
                        break block12;
                    }
                    resultOpenFileDialog = dir.getLocation().toOSString();
                }
                catch (Exception ce) {
                    ce.printStackTrace();
                }
            } else {
                String msg = "Select a file.";
                IFile file = null;
                ArrayList filters = new ArrayList();
                IFile[] files = WorkspaceResourceDialog.openFileSelection(null, null, (String)msg, (boolean)false, null, filters);
                try {
                    if (files.length != 0) {
                        file = files[0];
                    }
                    if (file != null) {
                        resultOpenFileDialog = this.showRelativePath ? file.getFullPath().toOSString().substring(1) : file.getLocation().toOSString();
                    }
                }
                catch (Exception ce) {
                    ce.printStackTrace();
                }
            }
        }
        if (!resultOpenFileDialog.equals(new String(""))) {
            this.field.setText(resultOpenFileDialog);
        }
    }
}

