/*
 * Decompiled with CFR 0.152.
 */
package org.somox.ui.runconfig.tabs;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.somox.analyzer.ModelAnalyzerTabGroupBlackboard;
import org.somox.common.SoMoXProjectPreferences;
import org.somox.ui.runconfig.tabs.WorkspaceButtonSelectionListener;

public class ModelAnalyzerInputTab
extends AbstractLaunchConfigurationTab {
    private ModelAnalyzerTabGroupBlackboard blackboard = null;
    Text projectName = null;
    Text inputFile = null;

    public void setModelAnalyzerTabGroupBlackboard(ModelAnalyzerTabGroupBlackboard blackboard) {
        this.blackboard = blackboard;
        if (this.inputFile == null) {
            this.updateBlackboard(null);
            return;
        }
        if (this.inputFile.getText() == null || this.inputFile.getText().equals("")) {
            this.updateBlackboard(null);
            return;
        }
        if (!ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(this.inputFile.getText()))) {
            this.updateBlackboard(null);
        } else {
            this.updateBlackboard(this.inputFile.getText());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SoMoXProjectPreferences.SOMOX_PROJECT_NAME, this.projectName.getText());
        configuration.setAttribute(SoMoXProjectPreferences.SOMOX_ANALYZER_INPUT_FILE, this.inputFile.getText());
    }

    public void createControl(Composite parent) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelAnalyzerInputTab.this.setDirty(true);
                ModelAnalyzerInputTab.this.updateLaunchConfigurationDialog();
            }
        };
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        Group projectDirectoryTypeGroup = new Group(container, 0);
        GridLayout glProjectDirectoryTypeGroup = new GridLayout();
        glProjectDirectoryTypeGroup.numColumns = 2;
        projectDirectoryTypeGroup.setLayout((Layout)glProjectDirectoryTypeGroup);
        projectDirectoryTypeGroup.setText("Project:");
        projectDirectoryTypeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.projectName = new Text((Composite)projectDirectoryTypeGroup, 2052);
        GridData gd_projectDirectory = new GridData(4, 0x1000000, true, false);
        gd_projectDirectory.widthHint = 200;
        this.projectName.setLayoutData((Object)gd_projectDirectory);
        this.projectName.addModifyListener(modifyListener);
        Button projectworkspaceButton = new Button((Composite)projectDirectoryTypeGroup, 0);
        projectworkspaceButton.setText("Workspace...");
        projectworkspaceButton.addSelectionListener((SelectionListener)new WorkspaceButtonSelectionListener(this.projectName, true, true, true));
        Group inputFileTypeGroup = new Group(container, 0);
        GridLayout glInputFileTypeGroup = new GridLayout();
        glInputFileTypeGroup.numColumns = 2;
        inputFileTypeGroup.setLayout((Layout)glInputFileTypeGroup);
        inputFileTypeGroup.setText("Input file:");
        inputFileTypeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.inputFile = new Text((Composite)inputFileTypeGroup, 2052);
        GridData gd_inputFile = new GridData(4, 0x1000000, true, false);
        gd_inputFile.widthHint = 200;
        this.inputFile.setLayoutData((Object)gd_inputFile);
        this.inputFile.addModifyListener(modifyListener);
        this.inputFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelAnalyzerInputTab.this.updateBlackboard(ModelAnalyzerInputTab.this.inputFile.getText());
            }
        });
        Button inputFileWorkspaceButton = new Button((Composite)inputFileTypeGroup, 0);
        inputFileWorkspaceButton.setText("Workspace...");
        inputFileWorkspaceButton.addSelectionListener((SelectionListener)new WorkspaceButtonSelectionListener(this.inputFile, false, true, true));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 302;
        composite.setLayoutData((Object)gridData);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.projectName.setText(configuration.getAttribute(SoMoXProjectPreferences.SOMOX_PROJECT_NAME, ""));
        }
        catch (CoreException coreException) {
            this.projectName.setText("");
        }
        try {
            this.inputFile.setText(configuration.getAttribute(SoMoXProjectPreferences.SOMOX_ANALYZER_INPUT_FILE, ""));
        }
        catch (CoreException coreException) {
            this.inputFile.setText("");
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.projectName.getText().equals("")) {
            this.setErrorMessage("Project not specified");
            return false;
        }
        if (!ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(this.projectName.getText()))) {
            this.setErrorMessage("Project " + this.projectName.getText() + " does not exist");
            return false;
        }
        if (this.inputFile.getText().equals("")) {
            this.setErrorMessage("Input file not specified");
            this.updateBlackboard(null);
            return false;
        }
        if (!ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(this.inputFile.getText()))) {
            this.setErrorMessage("Input file " + this.inputFile.getText() + " does not exist");
            this.updateBlackboard(null);
            return false;
        }
        return true;
    }

    public String getName() {
        return "General";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean canSave() {
        return true;
    }

    private void updateBlackboard(String inputFile) {
        if (this.blackboard != null) {
            if (this.blackboard.getSomoxAnalyzerInputFile() == null) {
                if (inputFile != null) {
                    this.blackboard.setSomoxAnalyzerInputFile(inputFile);
                }
                return;
            }
            if (!this.blackboard.getSomoxAnalyzerInputFile().equals(inputFile)) {
                this.blackboard.setSomoxAnalyzerInputFile(inputFile);
            }
        }
    }
}

