/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.util;

import de.fzi.gast.types.GASTClass;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jgrapht.DirectedGraph;
import org.somox.filter.BaseFilter;
import org.somox.filter.NotFilter;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.SourceClassEdgeFilter;
import org.somox.metrics.helper.TargetClassEdgeFilter;

public class AccessCacheGraph {
    private Logger logger = Logger.getLogger(AccessCacheGraph.class);
    private final DirectedGraph<GASTClass, ClassAccessGraphEdge> accessGraph;

    public AccessCacheGraph(DirectedGraph<GASTClass, ClassAccessGraphEdge> accessGraph) {
        this.accessGraph = accessGraph;
    }

    public long calculateNumberOfAccessesToClassesInSet(Set<GASTClass> sourceClasses, Set<GASTClass> targetClasses) {
        if (sourceClasses == null || targetClasses == null) {
            throw new IllegalArgumentException("Source or target classes must not be null");
        }
        TargetClassEdgeFilter filter = new TargetClassEdgeFilter(targetClasses);
        return this.getNumberOfFilteredOutgoingAccesses(sourceClasses, filter);
    }

    public long calculateNumberOfIncommingAccesses(Set<GASTClass> sourceClasses) {
        NotFilter filter = new NotFilter((BaseFilter)new SourceClassEdgeFilter(sourceClasses));
        long result = this.getNumberOfFilteredIncomingAccesses(sourceClasses, (BaseFilter<ClassAccessGraphEdge>)filter);
        return result;
    }

    public long calculateNumberOfExternalAccesses(Set<GASTClass> sourceClasses) {
        NotFilter filter = new NotFilter((BaseFilter)new TargetClassEdgeFilter(sourceClasses));
        long result = this.getNumberOfFilteredOutgoingAccesses(sourceClasses, (BaseFilter<ClassAccessGraphEdge>)filter);
        if (this.logger.isDebugEnabled()) {
            Set<GASTClass> otherClasses = this.substractSet(this.accessGraph.vertexSet(), sourceClasses);
            assert (result == this.calculateNumberOfAccessesToClassesInSet(sourceClasses, otherClasses));
        }
        return result;
    }

    public long calculateNumberOfInternalAccesses(Set<GASTClass> sourceClasses) {
        TargetClassEdgeFilter filter = new TargetClassEdgeFilter(sourceClasses);
        long result = this.getNumberOfFilteredOutgoingAccesses(sourceClasses, filter);
        if (this.logger.isDebugEnabled()) assert (result == this.calculateNumberOfAccessesToClassesInSet(sourceClasses, sourceClasses));
        return result;
    }

    private Set<GASTClass> substractSet(Set<GASTClass> source, Set<GASTClass> setToRemove) {
        HashSet<GASTClass> otherClasses = new HashSet<GASTClass>();
        for (GASTClass clazz : source) {
            if (setToRemove.contains(clazz)) continue;
            otherClasses.add(clazz);
        }
        return otherClasses;
    }

    private long getNumberOfFilteredOutgoingAccesses(Set<GASTClass> sourceClasses, BaseFilter<ClassAccessGraphEdge> filter) {
        if (sourceClasses == null) {
            throw new IllegalArgumentException("Source classes must not be null.");
        }
        long numberOfReferences = 0L;
        for (GASTClass clazz : sourceClasses) {
            try {
                if (clazz.getSimpleName().startsWith("I")) {
                    // empty if block
                }
                if (!this.accessGraph.vertexSet().contains(clazz)) {
                    // empty if block
                }
                assert (this.accessGraph.vertexSet().contains(clazz));
                if (this.accessGraph.outDegreeOf((Object)clazz) <= 0) continue;
                for (ClassAccessGraphEdge edge : filter.filter((Iterable)this.accessGraph.outgoingEdgesOf((Object)clazz))) {
                    numberOfReferences += (long)edge.getCount();
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("This should never happen as outDegree was > 0", e);
            }
        }
        return numberOfReferences;
    }

    private long getNumberOfFilteredIncomingAccesses(Set<GASTClass> sourceClasses, BaseFilter<ClassAccessGraphEdge> filter) {
        long numberOfReferences = 0L;
        for (GASTClass clazz : sourceClasses) {
            try {
                assert (this.accessGraph.vertexSet().contains(clazz));
                if (this.accessGraph.inDegreeOf((Object)clazz) <= 0) continue;
                for (ClassAccessGraphEdge edge : filter.filter((Iterable)this.accessGraph.incomingEdgesOf((Object)clazz))) {
                    numberOfReferences += (long)edge.getCount();
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("This should never happen as outDegree was > 0", e);
            }
        }
        return numberOfReferences;
    }
}

