/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.tabs;

import de.fzi.gast.core.Package;
import de.fzi.gast.core.Root;
import de.fzi.gast.types.GASTClass;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.somox.analyzer.BlackboardListener;
import org.somox.metrics.tabs.CheckboxContentProvider;
import org.somox.metrics.tabs.CheckboxLabelProvider;
import org.somox.metrics.tabs.MetricTab;

public class BlacklistTab
extends MetricTab {
    private final String DELIMITER = "\u00a7";
    protected Composite control;
    protected CheckboxTreeViewer checkboxTreeViewer;
    protected ICheckStateListener checkStateListener;
    protected Composite treeViewerControl;
    protected Composite textFieldControl;
    private Text textField;
    private Text addiditonalBlacklistTextfield;
    private Root root;
    StackLayout stackLayout;

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public boolean canSave() {
        return true;
    }

    public void setRoot(Root root) {
        if (this.root != root) {
            this.checkboxTreeViewer.getTree().dispose();
            this.checkboxTreeViewer = new CheckboxTreeViewer(this.treeViewerControl, 2048);
            this.checkboxTreeViewer.setContentProvider((IContentProvider)new CheckboxContentProvider());
            this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new CheckboxLabelProvider());
            Tree tree = this.checkboxTreeViewer.getTree();
            tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.checkboxTreeViewer.addCheckStateListener(this.checkStateListener);
        }
        this.root = root;
        this.checkboxTreeViewer.setInput((Object)this.root);
        if (this.root != null) {
            this.checkboxTreeViewer.setGrayed((Object)this.root, true);
        }
    }

    public void createControl(Composite parent) {
        this.checkStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                BlacklistTab.this.checkboxTreeViewer.setSubtreeChecked(event.getElement(), event.getChecked());
                BlacklistTab.this.setDirty(true);
                BlacklistTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(1, false));
        Composite mainComposite = new Composite(this.control, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.stackLayout = new StackLayout();
        mainComposite.setLayout((Layout)this.stackLayout);
        this.treeViewerControl = this.createControlTreeViewer(mainComposite);
        this.textFieldControl = this.createTextField(mainComposite);
        this.getModelAnalyzerTabGroupBlackboard().addBlackboardListener(new BlackboardListener(){

            public void blackboardChanged() {
                BlacklistTab.this.setRoot(BlacklistTab.this.getModelAnalyzerTabGroupBlackboard().getRoot());
                BlacklistTab.this.stackLayout.topControl = BlacklistTab.this.root == null ? BlacklistTab.this.textFieldControl : BlacklistTab.this.treeViewerControl;
            }
        });
        this.setRoot(this.getModelAnalyzerTabGroupBlackboard().getRoot());
        if (this.root == null) {
            this.switchFromTreeToText();
            this.stackLayout.topControl = this.textFieldControl;
        } else {
            this.switchFromTextToTree();
            this.stackLayout.topControl = this.treeViewerControl;
        }
    }

    private Composite createControlTreeViewer(Composite parentControl) {
        Composite treeViewerControl = new Composite(parentControl, 0);
        treeViewerControl.setLayout((Layout)new GridLayout(2, false));
        this.checkStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                BlacklistTab.this.checkboxTreeViewer.setSubtreeChecked(event.getElement(), event.getChecked());
                BlacklistTab.this.setDirty(true);
                BlacklistTab.this.updateLaunchConfigurationDialog();
            }
        };
        Label lblSpecifiyBlacklist = new Label(treeViewerControl, 0x1000000);
        lblSpecifiyBlacklist.setText("Specify blacklist");
        lblSpecifiyBlacklist.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.checkboxTreeViewer = new CheckboxTreeViewer(treeViewerControl, 2048);
        this.checkboxTreeViewer.setContentProvider((IContentProvider)new CheckboxContentProvider());
        this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new CheckboxLabelProvider());
        this.checkboxTreeViewer.addCheckStateListener(this.checkStateListener);
        Tree tree = this.checkboxTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Label additionalFilterLabel = new Label(treeViewerControl, 0);
        additionalFilterLabel.setText("Additional filter regex:");
        additionalFilterLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.addiditonalBlacklistTextfield = new Text(treeViewerControl, 2048);
        this.addiditonalBlacklistTextfield.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.addiditonalBlacklistTextfield.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BlacklistTab.this.setDirty(true);
                BlacklistTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite composite = new Composite(treeViewerControl, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        Button invertB = new Button(composite, 0);
        invertB.setText("Invert");
        invertB.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        invertB.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                BlacklistTab.this.checkboxTreeViewer.expandAll();
                Object[] elements = BlacklistTab.this.checkboxTreeViewer.getCheckedElements();
                BlacklistTab.this.checkboxTreeViewer.setAllChecked(true);
                int i = 0;
                while (i < elements.length) {
                    BlacklistTab.this.checkboxTreeViewer.setChecked(elements[i], false);
                    ++i;
                }
                BlacklistTab.this.checkboxTreeViewer.collapseAll();
                BlacklistTab.this.setDirty(true);
                BlacklistTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button selectB = new Button(composite, 0);
        selectB.setText("Select all");
        selectB.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        selectB.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                BlacklistTab.this.checkboxTreeViewer.expandAll();
                BlacklistTab.this.checkboxTreeViewer.setAllChecked(true);
                BlacklistTab.this.checkboxTreeViewer.collapseAll();
                BlacklistTab.this.setDirty(true);
                BlacklistTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button deselectB = new Button(composite, 0);
        deselectB.setText("Deselect all");
        deselectB.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        deselectB.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                BlacklistTab.this.checkboxTreeViewer.expandAll();
                BlacklistTab.this.checkboxTreeViewer.setAllChecked(false);
                BlacklistTab.this.checkboxTreeViewer.collapseAll();
                BlacklistTab.this.setDirty(true);
                BlacklistTab.this.updateLaunchConfigurationDialog();
            }
        });
        return treeViewerControl;
    }

    private void switchFromTreeToText() {
        Set<String> wildcards = this.getTreeSelection();
        wildcards.addAll(this.getTextField(this.addiditonalBlacklistTextfield));
        this.initializeTextField(this.getTreeSelection());
    }

    private void switchFromTextToTree() {
        this.initializeTreeViewer(this.getTextField(this.textField));
    }

    private Composite createTextField(Composite parentControl) {
        Group textFieldControl = new Group(parentControl, 0);
        textFieldControl.setLayout((Layout)new FillLayout(256));
        textFieldControl.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.textField = new Text((Composite)textFieldControl, 2626);
        ModifyListener textChangedListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BlacklistTab.this.setDirty(true);
                BlacklistTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.textField.addModifyListener(textChangedListener);
        textFieldControl.setSize(textFieldControl.getParent().getSize());
        return textFieldControl;
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.control;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public String getMessage() {
        return null;
    }

    public String getName() {
        return "Blacklist";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String wildcardString = configuration.getAttribute("org.somox.metrics.wildcards", "");
            StringTokenizer tokenizer = new StringTokenizer(wildcardString, "\u00a7");
            int tokenCount = tokenizer.countTokens();
            HashSet<String> wildcards = new HashSet<String>();
            int i = 0;
            while (i < tokenCount) {
                wildcards.add(tokenizer.nextToken());
                ++i;
            }
            this.initializeTreeViewer(wildcards);
            this.initializeTextField(wildcards);
            this.addiditonalBlacklistTextfield.setText(configuration.getAttribute("org.somox.metrics.wildcards.additional", ""));
        }
        catch (CoreException coreException) {}
    }

    private void initializeTreeViewer(Set<String> wildcardSet) {
        this.checkboxTreeViewer.expandAll();
        this.checkboxTreeViewer.setAllChecked(true);
        Object[] elements = this.checkboxTreeViewer.getCheckedElements();
        this.checkboxTreeViewer.setAllChecked(false);
        this.checkboxTreeViewer.collapseAll();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentElement = objectArray[n2];
            if (currentElement instanceof Package) {
                if (wildcardSet.contains(((Package)currentElement).getQualifiedName())) {
                    this.checkboxTreeViewer.setChecked(currentElement, true);
                }
            } else if (currentElement instanceof GASTClass && wildcardSet.contains(((GASTClass)currentElement).getQualifiedName())) {
                this.checkboxTreeViewer.setChecked(currentElement, true);
            }
            ++n2;
        }
    }

    private void initializeTextField(Set<String> wildcardSet) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iterator = wildcardSet.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            buffer.append(System.getProperty("line.separator"));
        }
        this.textField.setText(buffer.toString());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }

    public void launched(ILaunch launch) {
    }

    private Set<String> getTreeSelection() {
        Object[] checked = this.checkboxTreeViewer.getCheckedElements();
        HashSet<String> wildcards = new HashSet<String>();
        Object[] objectArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object current = objectArray[n2];
            if (current instanceof GASTClass) {
                wildcards.add(((GASTClass)current).getQualifiedName());
            } else if (current instanceof Package) {
                wildcards.add(((Package)current).getQualifiedName());
            }
            ++n2;
        }
        return wildcards;
    }

    private Set<String> getTextField(Text myTextField) {
        HashSet<String> completeResult = new HashSet<String>();
        String[] result = myTextField.getText().split(System.getProperty("line.separator"));
        int i = 0;
        while (i < result.length) {
            String[] commaResult = result[i].split(",");
            int j = 0;
            while (j < commaResult.length) {
                String[] semicolonResult = commaResult[j].split(";");
                int k = 0;
                while (k < semicolonResult.length) {
                    completeResult.add(semicolonResult[k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return completeResult;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Set<String> wildcards;
        if (this.stackLayout.topControl == this.textFieldControl) {
            wildcards = this.getTextField(this.textField);
        } else {
            wildcards = this.getTreeSelection();
            wildcards.addAll(this.getTextField(this.addiditonalBlacklistTextfield));
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iterator = wildcards.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            buffer.append("\u00a7");
        }
        configuration.setAttribute("org.somox.metrics.wildcards", buffer.toString());
        configuration.setAttribute("org.somox.metrics.wildcards.additional", this.addiditonalBlacklistTextfield.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.checkboxTreeViewer != null) {
            this.checkboxTreeViewer.setInput(null);
        }
        configuration.setAttribute("org.somox.metrics.wildcards.additional", "");
    }
}

