/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.structure;

import de.fzi.gast.core.Package;
import de.fzi.gast.core.Root;
import de.fzi.gast.types.GASTClass;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.DirectedGraph;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.AbstractMetric;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.metrics.structure.SliceLayerArchitectureQuality;

public class SubsystemComponent
extends AbstractMetric {
    public static final MetricID METRIC_ID = new MetricID("org.somox.metrics.SubsystemComponent");
    private IMetric sliceArchitectureMetric = null;

    @Override
    public void initialize(Root gastModel, SoMoXConfiguration somoxConfiguration, Map<MetricID, IMetric> allMetrics, DirectedGraph<GASTClass, ClassAccessGraphEdge> accessGraph, ComponentToImplementingClassesHelper componentToImplementingClassesHelper) {
        super.initialize(gastModel, somoxConfiguration, allMetrics, accessGraph, componentToImplementingClassesHelper);
        this.sliceArchitectureMetric = this.getMetric(allMetrics, SliceLayerArchitectureQuality.METRIC_ID);
    }

    @Override
    protected ClusteringRelation internalComputeDirected(ClusteringRelation relationToCompute) {
        Set<GASTClass> classes2;
        Set<GASTClass> classes1 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getComponentA());
        Package prefixPackage = this.computePrefix(classes1, classes2 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getComponentB()));
        if (prefixPackage == null) {
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return relationToCompute;
        }
        EList slices = prefixPackage.getSubPackages();
        EList layers = null;
        String subLayer = null;
        int max = 0;
        for (Package current : slices) {
            if (current.getSubPackages().size() < max) continue;
            layers = current.getSubPackages();
            max = layers.size();
        }
        if (max == 0 || layers.size() == 0 || layers == null) {
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return relationToCompute;
        }
        Package currentPackage = null;
        block1: for (GASTClass currentElement : classes1) {
            currentPackage = currentElement.getSurroundingPackage();
            if (currentPackage == null) continue;
            if (subLayer == null) {
                for (Package slicePackage : slices) {
                    if (!currentPackage.getQualifiedName().startsWith(slicePackage.getQualifiedName())) continue;
                    for (Package layerPackage : layers) {
                        if (!currentPackage.getQualifiedName().startsWith(String.valueOf(slicePackage.getQualifiedName()) + "." + layerPackage.getSimpleName())) continue;
                        subLayer = String.valueOf(slicePackage.getQualifiedName()) + "." + layerPackage.getSimpleName();
                        continue block1;
                    }
                    continue block1;
                }
                continue;
            }
            if (currentPackage.getQualifiedName().startsWith(subLayer)) continue;
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return relationToCompute;
        }
        block4: for (GASTClass currentElement : classes2) {
            currentPackage = currentElement.getSurroundingPackage();
            if (currentPackage == null) continue;
            if (subLayer == null) {
                for (Package slicePackage : slices) {
                    if (!currentPackage.getQualifiedName().startsWith(slicePackage.getQualifiedName())) continue;
                    for (Package layerPackage : layers) {
                        if (!currentPackage.getQualifiedName().startsWith(String.valueOf(slicePackage.getQualifiedName()) + "." + layerPackage.getSimpleName())) continue;
                        subLayer = String.valueOf(slicePackage.getQualifiedName()) + "." + layerPackage.getSimpleName();
                        continue block4;
                    }
                    continue block4;
                }
                continue;
            }
            if (currentPackage.getQualifiedName().startsWith(subLayer)) continue;
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return relationToCompute;
        }
        relationToCompute = this.sliceArchitectureMetric.computeDirected(relationToCompute);
        assert (relationToCompute.getResult().containsKey(this.sliceArchitectureMetric.getMID()));
        double slaq = relationToCompute.getResult().get(this.sliceArchitectureMetric.getMID());
        relationToCompute.setResultMetric(this.getMID(), slaq);
        return relationToCompute;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    private Package computePrefix(Set<GASTClass> elements1, Set<GASTClass> elements2) {
        Package prefix = null;
        LinkedList<GASTClass> elementsLeft = new LinkedList<GASTClass>();
        elementsLeft.addAll(elements1);
        elementsLeft.addAll(elements2);
        ListIterator iterator = elementsLeft.listIterator();
        while (iterator.hasNext()) {
            GASTClass current = (GASTClass)iterator.next();
            if (prefix == null && current.getSurroundingPackage() != null) {
                prefix = current.getSurroundingPackage();
            }
            if (prefix == null || current.getSurroundingPackage() == null || current.getQualifiedName().startsWith(prefix.getQualifiedName())) continue;
            if ((prefix = prefix.getSurroundingPackage()) == null) {
                return null;
            }
            iterator = elementsLeft.listIterator();
        }
        return prefix;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }
}

