/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.structure;

import de.fzi.gast.core.Package;
import de.fzi.gast.types.GASTClass;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.somox.metrics.AbstractMetric;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.MetricID;

public class SliceLayerArchitectureQuality
extends AbstractMetric {
    public static final MetricID METRIC_ID = new MetricID("org.somox.metrics.SliceLayerArchitectureQuality");

    @Override
    protected ClusteringRelation internalComputeDirected(ClusteringRelation relationToCompute) {
        Set<GASTClass> classes2;
        Set<GASTClass> classes1 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getComponentA());
        Package prefixPackage = this.computePrefix(classes1, classes2 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getComponentB()));
        if (prefixPackage == null) {
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return relationToCompute;
        }
        EList slices = prefixPackage.getSubPackages();
        EList layers = null;
        int max = 0;
        for (Package current : slices) {
            if (current.getSubPackages().size() < max) continue;
            layers = current.getSubPackages();
            max = layers.size();
        }
        if (max == 0) {
            relationToCompute.setResultMetric(this.getMID(), 1.0);
            return relationToCompute;
        }
        int expectedSubsystems = slices.size() * layers.size();
        int existingSubsystems = 0;
        for (Package currentSlice : slices) {
            EList currentLayers = currentSlice.getSubPackages();
            block2: for (Package currentReferencePackage : layers) {
                for (Package currentLayer : currentLayers) {
                    if (!currentLayer.getSimpleName().equals(currentReferencePackage.getSimpleName())) continue;
                    ++existingSubsystems;
                    continue block2;
                }
            }
        }
        if (expectedSubsystems == 0) {
            relationToCompute.setResultMetric(this.getMID(), 1.0);
            return relationToCompute;
        }
        relationToCompute.setResultMetric(this.getMID(), (double)existingSubsystems / (double)expectedSubsystems);
        return relationToCompute;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    private Package computePrefix(Set<GASTClass> elements1, Set<GASTClass> elements2) {
        String prefix = "";
        boolean prefixFound = false;
        Package currentPackage = null;
        for (GASTClass current : elements1) {
            if (current.getSurroundingPackage() == null) continue;
            currentPackage = current.getSurroundingPackage();
            break;
        }
        if (currentPackage == null) {
            for (GASTClass current : elements2) {
                if (current.getSurroundingPackage() == null) continue;
                currentPackage = current.getSurroundingPackage();
                break;
            }
        }
        if (currentPackage == null) {
            return null;
        }
        prefix = currentPackage.getQualifiedName();
        while (!prefixFound) {
            prefixFound = true;
            for (GASTClass current : elements1) {
                if (current.isInner() || current.getSurroundingPackage() == null || current.getSurroundingPackage().getQualifiedName().contains(prefix)) continue;
                prefixFound = false;
                break;
            }
            if (prefixFound) continue;
            if ((currentPackage = currentPackage.getSurroundingPackage()) == null) {
                return null;
            }
            prefix = currentPackage.getQualifiedName();
        }
        prefixFound = false;
        while (!prefixFound) {
            prefixFound = true;
            for (GASTClass current : elements2) {
                if (current.isInner() || current.getSurroundingPackage() == null || current.getSurroundingPackage().getQualifiedName().contains(prefix)) continue;
                prefixFound = false;
                break;
            }
            if (prefixFound) continue;
            if ((currentPackage = currentPackage.getSurroundingPackage()) == null) {
                return null;
            }
            prefix = currentPackage.getQualifiedName();
        }
        return currentPackage;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }
}

