/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.ratio;

import java.util.Map;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.AbstractComposedMetric;
import org.somox.metrics.ICompositionFunction;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.basic.AfferentCoupling;
import org.somox.metrics.basic.EfferentCoupling;

public class Instability
extends AbstractComposedMetric {
    public static final MetricID METRIC_ID = new MetricID("org.somox.metrics.Instability");
    private final ICompositionFunction instabilityFunction = new ICompositionFunction(){

        @Override
        public double computeOverallDirectedMetricValue(Map<MetricID, Double> metricValues) {
            double denominator = metricValues.get(EfferentCoupling.METRIC_ID) + metricValues.get(AfferentCoupling.METRIC_ID);
            if (denominator == 0.0) {
                return 0.0;
            }
            return metricValues.get(EfferentCoupling.METRIC_ID) / denominator;
        }
    };

    @Override
    protected IMetric[] getChildMetrics(Map<MetricID, IMetric> allMetrics) {
        return new IMetric[]{this.getMetric(allMetrics, EfferentCoupling.METRIC_ID), this.getMetric(allMetrics, AfferentCoupling.METRIC_ID)};
    }

    @Override
    protected ICompositionFunction getCompositionFunction(SoMoXConfiguration somoxConfiguration) {
        return this.instabilityFunction;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }
}

