/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.naming;

import de.fzi.gast.core.Root;
import de.fzi.gast.types.GASTClass;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jgrapht.DirectedGraph;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.AbstractMetric;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.metrics.naming.NamePair;
import org.somox.metrics.tabs.MetricTab;
import org.somox.metrics.tabs.NameResemblanceTab;
import uk.ac.shef.wit.simmetrics.similaritymetrics.InterfaceStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.JaroWinkler;

public class NameResemblance
extends AbstractMetric {
    public static final MetricID METRIC_ID = new MetricID("org.somox.metrics.NameResemblance");
    private static final String DELIMITER = "\u00a7";
    private static Logger logger = Logger.getLogger(NameResemblance.class);
    private static final InterfaceStringMetric resemblanceMetric = new JaroWinkler();
    private Map<NamePair, Float> nameResemblanceMap = new HashMap<NamePair, Float>();
    private Set<String> excludedPrefixes;
    private Set<String> excludedSuffixes;
    private static final IStringChangerStrategy prefixRemover = new IStringChangerStrategy(){

        @Override
        public String modify(String s, String parameter) {
            return s.substring(parameter.length());
        }

        @Override
        public boolean isAffected(String s, String parameter) {
            return s.startsWith(parameter);
        }
    };
    private static final IStringChangerStrategy suffixRemover = new IStringChangerStrategy(){

        @Override
        public String modify(String s, String parameter) {
            return s.substring(0, s.length() - parameter.length());
        }

        @Override
        public boolean isAffected(String s, String parameter) {
            return s.endsWith(parameter);
        }
    };

    @Override
    public void initialize(Root gastModel, SoMoXConfiguration somoxConfiguration, Map<MetricID, IMetric> allMetrics, DirectedGraph<GASTClass, ClassAccessGraphEdge> accessGraph, ComponentToImplementingClassesHelper componentToImplementingClassesHelper) {
        super.initialize(gastModel, somoxConfiguration, allMetrics, accessGraph, componentToImplementingClassesHelper);
        this.excludedPrefixes = this.tokenizeString(somoxConfiguration.getExcludedPrefixesForNameResemblance());
        this.excludedSuffixes = this.tokenizeString(somoxConfiguration.getExcludedSuffixesForNameResemblance());
        for (GASTClass class1 : accessGraph.vertexSet()) {
            for (GASTClass class2 : accessGraph.vertexSet()) {
                Float resemblance = this.nameResemblanceMap.get(new NamePair(class1, class2));
                if (resemblance != null) continue;
                resemblance = Float.valueOf(resemblanceMetric.getSimilarity(this.trimString(class1.getSimpleName()), this.trimString(class2.getSimpleName())));
                this.nameResemblanceMap.put(new NamePair(class1, class2), resemblance);
            }
        }
        this.nameResemblanceMap = Collections.unmodifiableMap(this.nameResemblanceMap);
    }

    @Override
    protected ClusteringRelation internalComputeDirected(ClusteringRelation relationToCompute) {
        Set<GASTClass> classes1 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getComponentA());
        Set<GASTClass> classes2 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getComponentB());
        int totalCompares = classes1.size() * classes2.size();
        double nameResemblance = 0.0;
        for (GASTClass class1 : classes1) {
            for (GASTClass class2 : classes2) {
                Float resemblance = this.nameResemblanceMap.get(new NamePair(class1, class2));
                if (resemblance == null) {
                    throw new RuntimeException("This should not happen as all classes are precomputed");
                }
                nameResemblance += (double)resemblance.floatValue();
            }
        }
        if (totalCompares == 0) {
            logger.debug((Object)"Resemblance Map had a size of 0");
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return relationToCompute;
        }
        relationToCompute.setResultMetric(this.getMID(), nameResemblance / (double)totalCompares);
        return relationToCompute;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public MetricTab getLaunchConfigurationTab() {
        return new NameResemblanceTab();
    }

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    private Set<String> collectAllSimpleNames(Set<GASTClass> classes) {
        HashSet<String> allSimpleTrimmedNames = new HashSet<String>();
        for (GASTClass clazz : classes) {
            allSimpleTrimmedNames.add(this.trimString(clazz.getSimpleName()));
        }
        return allSimpleTrimmedNames;
    }

    private String trimString(String name) {
        String result = this.modifyString(name, this.excludedPrefixes, prefixRemover);
        result = this.modifyString(name, this.excludedSuffixes, suffixRemover);
        return result;
    }

    private String modifyString(String name, Set<String> parameters, IStringChangerStrategy strategy) {
        boolean changed = true;
        block0: while (changed) {
            changed = false;
            for (String currentParameter : parameters) {
                if (!strategy.isAffected(name, currentParameter)) continue;
                changed = true;
                name = strategy.modify(name, currentParameter);
                continue block0;
            }
        }
        return name;
    }

    private Set<String> tokenizeString(String nameResemblancePrefixString) {
        HashSet<String> nameResemblancePrefixes = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(nameResemblancePrefixString, DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            nameResemblancePrefixes.add(tokenizer.nextToken());
        }
        return Collections.unmodifiableSet(nameResemblancePrefixes);
    }

    @Override
    public boolean isNormalised() {
        return true;
    }

    private static interface IStringChangerStrategy {
        public boolean isAffected(String var1, String var2);

        public String modify(String var1, String var2);
    }
}

