/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.helper;

import de.fzi.gast.types.GASTClass;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComponentToImplementingClassesHelper {
    private Map<ComponentImplementingClassesLink, Set<GASTClass>> mapOfImplementingClasses = new HashMap<ComponentImplementingClassesLink, Set<GASTClass>>();

    public synchronized Set<GASTClass> deriveImplementingClasses(ComponentImplementingClassesLink componentCandidate) {
        Set<GASTClass> result;
        if (!this.mapOfImplementingClasses.containsKey(componentCandidate)) {
            HashSet<GASTClass> classSet = new HashSet<GASTClass>();
            classSet.addAll((Collection<GASTClass>)componentCandidate.getImplementingClasses());
            for (ComponentImplementingClassesLink subComponent : componentCandidate.getSubComponents()) {
                classSet.addAll(this.deriveImplementingClasses(subComponent));
            }
            for (InterfaceSourceCodeLink providedIfLink : componentCandidate.getProvidedInterfaces()) {
                if (classSet.contains(providedIfLink.getGastClass())) continue;
                classSet.add(providedIfLink.getGastClass());
            }
            if (classSet.size() == 0) {
                throw new RuntimeException("Component must have associated classes");
            }
            this.mapOfImplementingClasses.put(componentCandidate, classSet);
        }
        if ((result = this.mapOfImplementingClasses.get(componentCandidate)) == null) {
            throw new IllegalStateException("The component to class cache did not contain a value which has been asserted to be there. There might be a concurrency issue here");
        }
        return result;
    }

    public Set<GASTClass> collectAllClasses(List<ComponentImplementingClassesLink> componentCandidates) {
        HashSet<GASTClass> allOtherComponentClasses = new HashSet<GASTClass>();
        for (ComponentImplementingClassesLink classLink : componentCandidates) {
            allOtherComponentClasses.addAll(this.deriveImplementingClasses(classLink));
        }
        return allOtherComponentClasses;
    }
}

