/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.helper;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.accessesPackage;
import de.fzi.gast.types.GASTClass;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.filter.AccessedTargetBlacklistFilter;
import org.somox.filter.BaseFilter;
import org.somox.filter.EClassBasedFilter;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.metrics.util.GraphPrinter;

public class Class2ClassAccessGraphHelper {
    private static final Logger logger = Logger.getLogger(Class2ClassAccessGraphHelper.class);
    private static final BaseFilter<GASTClass> primitiveTypeFilter = new BaseFilter<GASTClass>(){

        public boolean passes(GASTClass object) {
            return !object.isPrimitive();
        }
    };
    private static final EdgeFactory<GASTClass, ClassAccessGraphEdge> edgeFactory = new EdgeFactory<GASTClass, ClassAccessGraphEdge>(){

        public ClassAccessGraphEdge createEdge(GASTClass source, GASTClass target) {
            return new ClassAccessGraphEdge(source, target);
        }
    };
    private static final EClassBasedFilter<Access> accessFilter = new EClassBasedFilter(new EClass[]{accessesPackage.eINSTANCE.getInheritanceTypeAccess()});

    public static DirectedGraph<GASTClass, ClassAccessGraphEdge> computeFilteredClass2ClassAccessGraph(SoMoXConfiguration somoxConfiguration, Set<GASTClass> componentsImplementingClasses) {
        SimpleDirectedGraph accessGraph = new SimpleDirectedGraph(edgeFactory);
        for (GASTClass clazz : primitiveTypeFilter.filter(componentsImplementingClasses)) {
            accessGraph.addVertex((Object)clazz);
        }
        assert (Class2ClassAccessGraphHelper.noPrimitiveTypesAsVertexes((DirectedGraph<GASTClass, ClassAccessGraphEdge>)accessGraph));
        AccessedTargetBlacklistFilter filter = new AccessedTargetBlacklistFilter(somoxConfiguration.getBlacklistFilter());
        for (GASTClass clazz : componentsImplementingClasses) {
            Class2ClassAccessGraphHelper.addAccessesToGraph((Graph<GASTClass, ClassAccessGraphEdge>)accessGraph, filter, clazz);
        }
        assert (Class2ClassAccessGraphHelper.noPrimitiveTypesAsVertexes((DirectedGraph<GASTClass, ClassAccessGraphEdge>)accessGraph));
        if (logger.isDebugEnabled()) {
            GraphPrinter.dumpGraph(new ComponentToImplementingClassesHelper(), accessGraph, somoxConfiguration.getFileLocations().getAnalyserInputFile(), 0, 0);
        }
        return accessGraph;
    }

    private static boolean noPrimitiveTypesAsVertexes(DirectedGraph<GASTClass, ClassAccessGraphEdge> accessGraph) {
        boolean result = true;
        for (GASTClass clazz : accessGraph.vertexSet()) {
            result &= !clazz.isPrimitive();
        }
        return result;
    }

    private static void addAccessesToGraph(Graph<GASTClass, ClassAccessGraphEdge> graph, AccessedTargetBlacklistFilter filter, GASTClass clazz) {
        for (Access singleAccess : accessFilter.filter(filter.filter((Iterable)clazz.getAllAccesses()))) {
            GASTClass accessedClass = singleAccess.getAccessedClass();
            if (clazz == accessedClass) continue;
            ClassAccessGraphEdge edge = (ClassAccessGraphEdge)graph.getEdge((Object)clazz, (Object)accessedClass);
            if (edge == null) {
                if (graph.containsVertex((Object)clazz) && graph.containsVertex((Object)accessedClass)) {
                    edge = (ClassAccessGraphEdge)graph.addEdge((Object)clazz, (Object)accessedClass);
                } else {
                    logger.trace((Object)("Do not add edge between " + clazz + " and " + accessedClass));
                }
            }
            if (edge == null) continue;
            edge.incrementCount();
        }
    }
}

