/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.basic;

import de.fzi.gast.types.GASTClass;
import java.util.Set;
import org.somox.filter.BaseFilter;
import org.somox.filter.FilteredCollectionsFactory;
import org.somox.metrics.AbstractCountingMetric;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.MetricID;

public class AbstractTypesCount
extends AbstractCountingMetric {
    public static final MetricID METRIC_ID = new MetricID("org.somox.metric.basic.AbstractTypesCount");
    private static final BaseFilter<GASTClass> abstractClassesFilter = new BaseFilter<GASTClass>(){

        public boolean passes(GASTClass object) {
            return object.isAbstract() || object.isInterface();
        }
    };

    @Override
    protected ClusteringRelation internalComputeDirected(ClusteringRelation relationToCompute) {
        Set<GASTClass> allClasses = this.calculateUnion(relationToCompute.getComponentA(), relationToCompute.getComponentB());
        relationToCompute.setResultMetric(this.getMID(), FilteredCollectionsFactory.getFilteredHashSet(abstractClassesFilter, allClasses).size());
        return relationToCompute;
    }

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }
}

