/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.somox.metrics.AbstractMetric;
import org.somox.metrics.Activator;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.dSL.Metric;
import org.somox.metrics.dSL.MetricModel;
import org.somox.metrics.dslvisitor.DSLConfigurationVisitor;

public class MetricsRegistry {
    private static final String METRIC_DEFINITION_ATTRIBUTE_NAME = "metric_definition";
    private static final String ORG_SOMOX_CORE_METRIC_EXTENSION_ID = "org.somox.core.metric";
    private static final Logger logger = Logger.getLogger(MetricsRegistry.class);

    public static Map<MetricID, IMetric> getRegisteredMetrics() {
        return Collections.unmodifiableMap(MetricsRegistry.internalGetRegisteredMetrics());
    }

    private static Map<MetricID, IMetric> internalGetRegisteredMetrics() {
        IConfigurationElement[] metricExtensions;
        HashMap<MetricID, IMetric> allMetrics = new HashMap<MetricID, IMetric>();
        IConfigurationElement[] iConfigurationElementArray = metricExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(ORG_SOMOX_CORE_METRIC_EXTENSION_ID);
        int n = metricExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement metricExtension = iConfigurationElementArray[n2];
            if (metricExtension.getName().equals("metric")) {
                Object o = null;
                try {
                    o = metricExtension.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", "Warning: Specified Analyzer Metric " + metricExtension.getName() + " cannot be loaded."));
                    throw new RuntimeException("Eclipse core failure", e);
                }
                if (o == null || !(o instanceof AbstractMetric)) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", "Warning: Specified Analyzer Metric " + metricExtension.getName() + " cannot be loaded."));
                    throw new RuntimeException("Eclipse core failure. Could not instanciate metric", null);
                }
                allMetrics.put(((AbstractMetric)o).getMID(), (AbstractMetric)o);
            } else {
                String resourcePath = metricExtension.getAttribute(METRIC_DEFINITION_ATTRIBUTE_NAME);
                MetricModel metricDefinitions = MetricsRegistry.loadResource(String.valueOf(metricExtension.getContributor().getName()) + "/" + resourcePath);
                if (metricDefinitions != null) {
                    for (EObject o : metricDefinitions.getMetrics()) {
                        IMetric m = MetricsRegistry.parseMetricDefintion((Metric)o);
                        if (m == null) continue;
                        allMetrics.put(m.getMID(), m);
                    }
                } else {
                    Activator.getPlugin().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", "Failed to load a metric definition from a metric DSL file. Some metrics mightbe unavailable and further errors may occur during SoMoX runs"));
                }
            }
            ++n2;
        }
        return allMetrics;
    }

    private static IMetric parseMetricDefintion(Metric o) {
        logger.info((Object)("Parsing metric definition " + o.getName()));
        return (IMetric)new DSLConfigurationVisitor().doSwitch((EObject)o);
    }

    private static MetricModel loadResource(String resourcePath) {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createPlatformPluginURI((String)resourcePath, (boolean)true));
        try {
            r.load(new HashMap());
        }
        catch (IOException e) {
            Activator.getPlugin().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", 0, "Failed to load metrics from stored DSL", (Throwable)e));
            return null;
        }
        return (MetricModel)r.getContents().get(0);
    }
}

