/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics;

import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.somox.metrics.MetricID;

public class ClusteringRelation {
    private final ComponentImplementingClassesLink componentA;
    private final ComponentImplementingClassesLink componentB;
    private final Map<MetricID, Double> result = new HashMap<MetricID, Double>();
    private final Map<MetricID, Double> unmodifiableResult = Collections.unmodifiableMap(this.result);
    private static DecimalFormat format = new DecimalFormat(".00");

    public ClusteringRelation(ComponentImplementingClassesLink componentA, ComponentImplementingClassesLink componentB) {
        if (componentA == null || componentB == null || componentA == componentB) {
            throw new IllegalArgumentException("Components must not be null or the same in a clustering relation");
        }
        this.componentA = componentA;
        this.componentB = componentB;
    }

    public ComponentImplementingClassesLink getComponentA() {
        return this.componentA;
    }

    public ComponentImplementingClassesLink getComponentB() {
        return this.componentB;
    }

    public List<ComponentImplementingClassesLink> getComponents() {
        LinkedList<ComponentImplementingClassesLink> result = new LinkedList<ComponentImplementingClassesLink>();
        result.add(this.componentA);
        result.add(this.componentB);
        return result;
    }

    public void setResultMetric(MetricID metric, double value) {
        assert (!this.result.containsKey(metric));
        this.result.put(metric, value);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<MetricID, Double> metricResult : this.result.entrySet()) {
            String metricFullName = metricResult.getKey().getMetricID();
            stringBuilder.append(metricFullName.substring(metricFullName.lastIndexOf(".") + 1));
            stringBuilder.append(" = ");
            stringBuilder.append(format.format(metricResult.getValue()));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public Map<MetricID, Double> getResult() {
        return this.unmodifiableResult;
    }
}

