/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics;

import java.util.Map;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.AbstractComposedMetric;
import org.somox.metrics.ICompositionFunction;
import org.somox.metrics.MetricID;

public abstract class AbstractStepwiseMetric
extends AbstractComposedMetric {
    protected BoundAndWeightStruct[] boundsAndWeights = this.getBoundsAndWeights();
    private final ICompositionFunction function = new ICompositionFunction(){

        @Override
        public double computeOverallDirectedMetricValue(Map<MetricID, Double> metricValues) {
            if (!$assertionsDisabled && AbstractStepwiseMetric.this.getAllChildMetrics().length != 1) {
                throw new AssertionError();
            }
            double innerMetricValue = metricValues.get(AbstractStepwiseMetric.this.getAllChildMetrics()[0].getMID());
            BoundAndWeightStruct[] boundAndWeightStructArray = AbstractStepwiseMetric.this.boundsAndWeights;
            int n = AbstractStepwiseMetric.this.boundsAndWeights.length;
            int n2 = 0;
            while (n2 < n) {
                BoundAndWeightStruct range = boundAndWeightStructArray[n2];
                if (innerMetricValue < range.getUpperBound()) {
                    return innerMetricValue * range.getWeight();
                }
                ++n2;
            }
            return innerMetricValue;
        }
    };

    @Override
    protected ICompositionFunction getCompositionFunction(SoMoXConfiguration somoxConfiguration) {
        return this.function;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }

    protected abstract BoundAndWeightStruct[] getBoundsAndWeights();

    public class BoundAndWeightStruct {
        private final double upperBound;
        private final double weight;

        public BoundAndWeightStruct(double upperBound, double weight) {
            this.upperBound = upperBound;
            this.weight = weight;
        }

        public double getUpperBound() {
            return this.upperBound;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

