/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics;

import java.util.Map;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.AbstractComposedMetric;
import org.somox.metrics.ICompositionFunction;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;

public abstract class AbstractRatioMetric
extends AbstractComposedMetric
implements IMetric {
    private final ICompositionFunction ratioFunction = new ICompositionFunction(){

        @Override
        public double computeOverallDirectedMetricValue(Map<MetricID, Double> metricValues) {
            double denominator = metricValues.get(AbstractRatioMetric.this.getDenominatorMetricID());
            if (denominator == 0.0) {
                return 0.0;
            }
            return metricValues.get(AbstractRatioMetric.this.getNumeratorMetricID()) / denominator;
        }
    };

    @Override
    protected IMetric[] getChildMetrics(Map<MetricID, IMetric> allMetrics) {
        return new IMetric[]{this.getMetric(allMetrics, this.getNumeratorMetricID()), this.getMetric(allMetrics, this.getDenominatorMetricID())};
    }

    protected abstract MetricID getNumeratorMetricID();

    protected abstract MetricID getDenominatorMetricID();

    @Override
    protected ICompositionFunction getCompositionFunction(SoMoXConfiguration somoxConfiguration) {
        return this.ratioFunction;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }
}

