/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics;

import de.fzi.gast.core.Root;
import de.fzi.gast.types.GASTClass;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jgrapht.DirectedGraph;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.AbstractMetric;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.ICompositionFunction;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;

public abstract class AbstractComposedMetric
extends AbstractMetric {
    private static final Logger logger = Logger.getLogger(AbstractComposedMetric.class);
    private IMetric[] allChildMetrics;
    private ICompositionFunction compositionFunction = null;

    @Override
    public void initialize(Root gastModel, SoMoXConfiguration somoxConfiguration, Map<MetricID, IMetric> allMetrics, DirectedGraph<GASTClass, ClassAccessGraphEdge> accessGraph, ComponentToImplementingClassesHelper componentToImplementingClassesHelper) {
        super.initialize(gastModel, somoxConfiguration, allMetrics, accessGraph, componentToImplementingClassesHelper);
        this.compositionFunction = this.getCompositionFunction(somoxConfiguration);
        this.allChildMetrics = this.getChildMetrics(allMetrics);
    }

    @Override
    protected ClusteringRelation internalComputeDirected(ClusteringRelation relationToCompute) {
        IMetric m;
        IMetric[] iMetricArray = this.allChildMetrics;
        int n = this.allChildMetrics.length;
        int n2 = 0;
        while (n2 < n) {
            m = iMetricArray[n2];
            if (!relationToCompute.getResult().containsKey(m.getMID())) {
                m.computeDirected(relationToCompute);
            }
            ++n2;
        }
        if (logger.isDebugEnabled()) {
            iMetricArray = this.allChildMetrics;
            n = this.allChildMetrics.length;
            n2 = 0;
            while (n2 < n) {
                m = iMetricArray[n2];
                assert (relationToCompute.getResult().containsKey(m.getMID()));
                assert (relationToCompute.getResult().get(m.getMID()) != null);
                ++n2;
            }
        }
        relationToCompute.setResultMetric(this.getMID(), this.compositionFunction.computeOverallDirectedMetricValue(relationToCompute.getResult()));
        return relationToCompute;
    }

    @Override
    public boolean isCommutative() {
        boolean result = true;
        IMetric[] iMetricArray = this.allChildMetrics;
        int n = this.allChildMetrics.length;
        int n2 = 0;
        while (n2 < n) {
            IMetric m = iMetricArray[n2];
            result &= m.isCommutative();
            ++n2;
        }
        return result;
    }

    protected abstract IMetric[] getChildMetrics(Map<MetricID, IMetric> var1);

    protected abstract ICompositionFunction getCompositionFunction(SoMoXConfiguration var1);

    public IMetric[] getAllChildMetrics() {
        return this.allChildMetrics;
    }

    protected IMetric[] metricIDToIMetric(MetricID[] metrics, Map<MetricID, IMetric> allMetrics) {
        IMetric[] result = new IMetric[metrics.length];
        int i = 0;
        while (i < metrics.length) {
            result[i] = allMetrics.get(metrics[i]);
            ++i;
        }
        return result;
    }
}

