lexer grammar InternalDSL;
@header {
package org.somox.metrics.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

T12 : 'import' ;
T13 : ';' ;
T14 : 'extern' ;
T15 : 'Metrics' ;
T16 : '{' ;
T17 : '}' ;
T18 : 'Metric' ;
T19 : '(' ;
T20 : ',' ;
T21 : ')' ;
T22 : 'parameters' ;
T23 : '};' ;
T24 : 'Parameter' ;
T25 : 'Const' ;
T26 : '=' ;
T27 : 'Basic' ;
T28 : 'WeigthedSum' ;
T29 : 'Stepwise' ;
T30 : '[' ;
T31 : ']' ;
T32 : 'Ratio' ;
T33 : '/' ;
T34 : '<' ;
T35 : '>' ;
T36 : '.' ;

// $ANTLR src "../org.somox.metrics.dsl/src-gen/org/somox/metrics/parser/antlr/internal/InternalDSL.g" 1094
RULE_DOUBLE : '-'? RULE_INT '.' RULE_INT;

// $ANTLR src "../org.somox.metrics.dsl/src-gen/org/somox/metrics/parser/antlr/internal/InternalDSL.g" 1096
RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

// $ANTLR src "../org.somox.metrics.dsl/src-gen/org/somox/metrics/parser/antlr/internal/InternalDSL.g" 1098
RULE_INT : ('0'..'9')+;

// $ANTLR src "../org.somox.metrics.dsl/src-gen/org/somox/metrics/parser/antlr/internal/InternalDSL.g" 1100
RULE_STRING : ('"' ('\\' ('b'|'t'|'n'|'f'|'r'|'"'|'\''|'\\')|~(('\\'|'"')))* '"'|'\'' ('\\' ('b'|'t'|'n'|'f'|'r'|'"'|'\''|'\\')|~(('\\'|'\'')))* '\'');

// $ANTLR src "../org.somox.metrics.dsl/src-gen/org/somox/metrics/parser/antlr/internal/InternalDSL.g" 1102
RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

// $ANTLR src "../org.somox.metrics.dsl/src-gen/org/somox/metrics/parser/antlr/internal/InternalDSL.g" 1104
RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

// $ANTLR src "../org.somox.metrics.dsl/src-gen/org/somox/metrics/parser/antlr/internal/InternalDSL.g" 1106
RULE_WS : (' '|'\t'|'\r'|'\n')+;

// $ANTLR src "../org.somox.metrics.dsl/src-gen/org/somox/metrics/parser/antlr/internal/InternalDSL.g" 1108
RULE_ANY_OTHER : .;


