lexer grammar InternalDSL;
@header {
package org.somox.metrics.contentassist.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.ui.common.editor.contentassist.antlr.internal.Lexer;
}

T12 : 'Basic' ;
T13 : 'Metrics' ;
T14 : '{' ;
T15 : '}' ;
T16 : 'import' ;
T17 : ';' ;
T18 : 'extern' ;
T19 : 'Metric' ;
T20 : '(' ;
T21 : ',' ;
T22 : ')' ;
T23 : '};' ;
T24 : 'parameters' ;
T25 : 'Parameter' ;
T26 : 'Const' ;
T27 : '=' ;
T28 : 'WeigthedSum' ;
T29 : 'Stepwise' ;
T30 : '[' ;
T31 : ']' ;
T32 : 'Ratio' ;
T33 : '/' ;
T34 : '<' ;
T35 : '>' ;
T36 : '.' ;

// $ANTLR src "../org.somox.metrics.dsl.ui/src-gen/org/somox/metrics/contentassist/antlr/internal/InternalDSL.g" 2424
RULE_DOUBLE : '-'? RULE_INT '.' RULE_INT;

// $ANTLR src "../org.somox.metrics.dsl.ui/src-gen/org/somox/metrics/contentassist/antlr/internal/InternalDSL.g" 2426
RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

// $ANTLR src "../org.somox.metrics.dsl.ui/src-gen/org/somox/metrics/contentassist/antlr/internal/InternalDSL.g" 2428
RULE_INT : ('0'..'9')+;

// $ANTLR src "../org.somox.metrics.dsl.ui/src-gen/org/somox/metrics/contentassist/antlr/internal/InternalDSL.g" 2430
RULE_STRING : ('"' ('\\' ('b'|'t'|'n'|'f'|'r'|'"'|'\''|'\\')|~(('\\'|'"')))* '"'|'\'' ('\\' ('b'|'t'|'n'|'f'|'r'|'"'|'\''|'\\')|~(('\\'|'\'')))* '\'');

// $ANTLR src "../org.somox.metrics.dsl.ui/src-gen/org/somox/metrics/contentassist/antlr/internal/InternalDSL.g" 2432
RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

// $ANTLR src "../org.somox.metrics.dsl.ui/src-gen/org/somox/metrics/contentassist/antlr/internal/InternalDSL.g" 2434
RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

// $ANTLR src "../org.somox.metrics.dsl.ui/src-gen/org/somox/metrics/contentassist/antlr/internal/InternalDSL.g" 2436
RULE_WS : (' '|'\t'|'\r'|'\n')+;

// $ANTLR src "../org.somox.metrics.dsl.ui/src-gen/org/somox/metrics/contentassist/antlr/internal/InternalDSL.g" 2438
RULE_ANY_OTHER : .;


