/*
 * Decompiled with CFR 0.152.
 */
package org.somox.filter;

import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.Visibilities;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.somox.filter.BaseFilter;

public class DataObjectFilter
extends BaseFilter<GASTClass> {
    private static final Logger logger = Logger.getLogger(DataObjectFilter.class);
    private final String[] filteredPrefixes = new String[]{"is", "get", "set", "equals", "hashcode"};

    @Override
    public boolean passes(GASTClass object) {
        EList allMethods = object.getMethods();
        for (Method m : allMethods) {
            if (m.getVisibility() != Visibilities.VISIBILITYPUBLIC || !this.isNotGetterOrSetter(m)) continue;
            return true;
        }
        logger.debug((Object)("Removed GAST Class " + object.getSimpleName() + " from component candidates as it is a datatype"));
        return false;
    }

    private boolean isNotGetterOrSetter(Method m) {
        boolean result = false;
        String simpleMethodName = m.getSimpleName().toLowerCase();
        String[] stringArray = this.filteredPrefixes;
        int n = this.filteredPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            result |= simpleMethodName.startsWith(prefix);
            ++n2;
        }
        return !result;
    }
}

