/*
 * Decompiled with CFR 0.152.
 */
package org.somox.filter;

import de.fzi.gast.types.GASTClass;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.somox.filter.BaseFilter;

public class BlacklistFilter
extends BaseFilter<GASTClass> {
    private static Logger logger = Logger.getLogger(BlacklistFilter.class);
    private Pattern matchPattern = null;

    public BlacklistFilter(Set<String> blacklist) {
        this.matchPattern = BlacklistFilter.deriveMatchPattern(blacklist);
    }

    @Override
    public boolean passes(GASTClass object) {
        return !this.classMatchesBlacklist(object);
    }

    private static Pattern deriveMatchPattern(Set<String> blacklist) {
        StringBuffer sw = new StringBuffer();
        for (String s : blacklist) {
            sw.append(s);
            sw.append("|");
        }
        if (sw.length() > 0) {
            sw.deleteCharAt(sw.length() - 1);
        }
        Pattern matchPattern = Pattern.compile(sw.toString(), 2);
        logger.debug((Object)("Initialised Blacklist filter with pattern " + matchPattern.toString()));
        return matchPattern;
    }

    private boolean classMatchesBlacklist(GASTClass currentClass) {
        boolean result = this.matchPattern.matcher(currentClass.getQualifiedName()).matches();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Blacklist filter matches " + currentClass.getQualifiedName() + ": " + result));
        }
        return result;
    }
}

