/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.metrics.tabs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.somox.analyzer.simplemodelanalyzer.Activator;
import org.somox.common.MetricsDetails;
import org.somox.common.SoMoXProjectPreferences;
import org.somox.metrics.tabs.MetricTab;

public class WeightsTab
extends MetricTab {
    private static final String CONFIG_SIMPLE_ANALYZER_PROPERTIES_FILE = "/config/SimpleAnalyzer.properties";
    protected Composite control;
    private static Logger logger = Logger.getLogger(WeightsTab.class);
    private ArrayList<Label> keyLabels;
    private ArrayList<Slider> valueSliders;
    private ArrayList<Label> valueLabels;
    private static SoMoXProjectPreferences projectPreferences = new SoMoXProjectPreferences();

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public boolean canSave() {
        return true;
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 2048);
        this.control.setLayout((Layout)new GridLayout(3, false));
        this.keyLabels = new ArrayList();
        this.valueSliders = new ArrayList();
        this.valueLabels = new ArrayList();
        int weightCounter = 0;
        for (MetricsDetails metricDetail : WeightsTab.projectPreferences.metricDetails) {
            Label keyLabel = new Label(this.control, 0);
            keyLabel.setText(metricDetail.metricLabel);
            keyLabel.setToolTipText(metricDetail.metricExplanantion);
            this.keyLabels.add(keyLabel);
            final Label valueLabel = new Label(this.control, 2048);
            GridData gd = new GridData();
            gd.minimumWidth = 100;
            gd.widthHint = 30;
            valueLabel.setAlignment(0x1000000);
            valueLabel.setLayoutData((Object)gd);
            this.valueLabels.add(valueLabel);
            final Slider slider = new Slider(this.control, 256);
            slider.setMinimum(0);
            slider.setMaximum(110);
            slider.setIncrement(1);
            slider.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    valueLabel.setText(String.valueOf(slider.getSelection()));
                    WeightsTab.this.setDirty(true);
                    WeightsTab.this.updateLaunchConfigurationDialog();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.valueSliders.add(slider);
            ++weightCounter;
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.control;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public String getMessage() {
        return null;
    }

    public String getName() {
        return "Weights";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            int i = 0;
            while (i < this.valueSliders.size()) {
                String value = configuration.getAttribute(((MetricsDetails)WeightsTab.projectPreferences.metricDetails.get((int)i)).metricWeightPeferenceName, "");
                System.out.println("value was:" + value);
                this.valueSliders.get(i).setSelection(Integer.valueOf(value).intValue());
                this.valueLabels.get(i).setText(String.valueOf(value));
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }

    public void launched(ILaunch launch) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int i = 0;
        while (i < this.valueSliders.size()) {
            int value = this.valueSliders.get(i).getSelection();
            configuration.setAttribute(((MetricsDetails)WeightsTab.projectPreferences.metricDetails.get((int)i)).metricWeightPeferenceName, String.valueOf(value));
            ++i;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        WeightsTab.setDefault(configuration);
    }

    public static void setDefault(ILaunchConfigurationWorkingCopy configuration) {
        Properties properties = new Properties();
        try {
            InputStream inStream = Activator.getDefault().getBundle().getEntry(CONFIG_SIMPLE_ANALYZER_PROPERTIES_FILE).openStream();
            properties.load(inStream);
            for (MetricsDetails metricsDetails : WeightsTab.projectPreferences.metricDetails) {
                configuration.setAttribute(metricsDetails.metricWeightPeferenceName, properties.getProperty(metricsDetails.metricWeightPeferenceName));
            }
            for (Object object : configuration.getAttributes().entrySet()) {
                if (object != null) continue;
                logger.error((Object)"At least one metric weight was not defined in the properties file");
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not read property file /config/SimpleAnalyzer.properties with metric defaults", (Throwable)e);
            e.printStackTrace();
        }
        catch (CoreException e) {
            logger.error((Object)"Could not read property file with metric defaults", (Throwable)e);
            e.printStackTrace();
        }
    }
}

