/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.Method;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.types.GASTClass;
import eu.qimpress.qimpressgast.GASTBehaviour;
import eu.qimpress.qimpressgast.qimpressgastFactory;
import eu.qimpress.samm.behaviour.BehaviourFactory;
import eu.qimpress.samm.behaviour.GastBehaviourStub;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.MethodLevelSourceCodeLink;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.detection.util.EqualityChecker;
import org.somox.configuration.SoMoXConfiguration;

public class GASTBehaviourBuilder
extends AbstractBuilder {
    private static final Logger logger = Logger.getLogger(GASTBehaviourBuilder.class);

    public GASTBehaviourBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
    }

    public void addGASTBehaviourToPrimitiveComponent(PrimitiveComponent component, InterfacePort providedRole) {
        for (Operation operation : providedRole.getInterfaceType().getSignatures()) {
            this.addGASTBehaviourToPrimitiveComponent(component, operation);
        }
    }

    private void addGASTBehaviourToPrimitiveComponent(PrimitiveComponent component, Operation operation) {
        MethodLevelSourceCodeLink link = this.getMethodLevelSourceCodeLink(operation);
        if (link == null) {
            throw new RuntimeException("Found interface with operations for which no method link exists. This should never happen!");
        }
        link.setComponentType((ComponentType)component);
        this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink().add((Object)link);
        GastBehaviourStub gastBehaviourStub = BehaviourFactory.eINSTANCE.createGastBehaviourStub();
        gastBehaviourStub.setOperation(link.getOperation());
        GASTBehaviour gastBehaviour = qimpressgastFactory.eINSTANCE.createGASTBehaviour();
        component.getOperationBehaviour().add((Object)gastBehaviourStub);
        BlockStatement methodBody = this.getFunctionImplementation(link.getFunction(), this.findComponenentLink((ComponentType)component));
        gastBehaviour.setBlockstatement(methodBody);
        if (gastBehaviour.getBlockstatement() == null || gastBehaviour.getBlockstatement().getStatements().size() == 0) {
            logger.warn((Object)("Empty behaviour added for " + gastBehaviourStub.getName() + "! Reverse engineering of behaviour will NOT be able to succeed for this method!"));
        }
        gastBehaviour.setGastbehaviourstub(gastBehaviourStub);
        this.analysisResult.getGastBehaviourRepository().getGastbehaviour().add((Object)gastBehaviour);
    }

    private BlockStatement getFunctionImplementation(Function function, ComponentImplementingClassesLink component) {
        for (GASTClass implementingClass : component.getImplementingClasses()) {
            for (Method implementedMethod : implementingClass.getMethods()) {
                if (!EqualityChecker.areFunctionsEqual(function, (Function)implementedMethod)) continue;
                return implementedMethod.getBody();
            }
        }
        logger.error((Object)("No method implemementation found for method " + function.getSimpleName() + " for component " + component.getComponent().getName()));
        return null;
    }

    private ComponentImplementingClassesLink findComponenentLink(ComponentType component) {
        for (ComponentImplementingClassesLink compLink : this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
            if (!compLink.getComponent().equals(component)) continue;
            return compLink;
        }
        logger.error((Object)("No component link found for component " + component.getName()));
        return null;
    }

    private MethodLevelSourceCodeLink getMethodLevelSourceCodeLink(Operation operation) {
        assert (this.operationUnique(operation, (EList<MethodLevelSourceCodeLink>)this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink()));
        for (MethodLevelSourceCodeLink link : this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink()) {
            if (operation != link.getOperation()) continue;
            return link;
        }
        return null;
    }

    private boolean operationUnique(Operation operation, EList<MethodLevelSourceCodeLink> methodLevelSourceCodeLink) {
        int i = 0;
        for (MethodLevelSourceCodeLink link : this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink()) {
            if (operation != link.getOperation()) continue;
            ++i;
        }
        return i == 1;
    }
}

