/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import org.apache.log4j.Logger;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.configuration.SoMoXConfiguration;

public class AssemblyConnectorBuilder
extends AbstractBuilder {
    private static final Logger logger = Logger.getLogger(AssemblyConnectorBuilder.class);

    public AssemblyConnectorBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
    }

    public static Connector createAssemblyConnector(CompositeStructure parentComponent, Port requiredPort, Port providedPort, ComponentType requiredComponentType, ComponentType providedComponentType) {
        Connector newConnector = AssemblyConnectorBuilder.createAssemblyConnectorEntity(parentComponent, (NamedEntity)requiredComponentType, (NamedEntity)providedComponentType);
        SubcomponentEndpoint sourceEndpoint = AssemblyConnectorBuilder.addSubcomponentEndpoint(newConnector, parentComponent, requiredComponentType);
        sourceEndpoint.setPort(requiredPort);
        SubcomponentEndpoint targetEndpoint = AssemblyConnectorBuilder.addSubcomponentEndpoint(newConnector, parentComponent, providedComponentType);
        targetEndpoint.setPort(providedPort);
        return newConnector;
    }

    public static Connector createAssemblyConnector(CompositeStructure parentComponent, Port requiredPort, Port providedPort, SubcomponentInstance requiredComponentInstance, SubcomponentInstance providedComponentInstance) {
        Connector newConnector = AssemblyConnectorBuilder.createAssemblyConnectorEntity(parentComponent, (NamedEntity)requiredComponentInstance, (NamedEntity)providedComponentInstance);
        SubcomponentEndpoint sourceEndpoint = AssemblyConnectorBuilder.addSubcomponentEndpoint(newConnector, requiredComponentInstance);
        sourceEndpoint.setPort(requiredPort);
        SubcomponentEndpoint targetEndpoint = AssemblyConnectorBuilder.addSubcomponentEndpoint(newConnector, providedComponentInstance);
        targetEndpoint.setPort(providedPort);
        return newConnector;
    }

    private static Connector createAssemblyConnectorEntity(CompositeStructure parentComponent, NamedEntity requiredComponentType, NamedEntity providedComponentType) {
        logger.debug((Object)("Creating new assembly connector from " + requiredComponentType.getName() + " to " + providedComponentType.getName()));
        Connector newConnector = StaticstructureFactory.eINSTANCE.createConnector();
        parentComponent.getConnector().add((Object)newConnector);
        newConnector.setDocumentation("Assembly Connector from " + requiredComponentType.getName() + " to " + providedComponentType.getName());
        return newConnector;
    }

    private static SubcomponentEndpoint addSubcomponentEndpoint(Connector newConnector, SubcomponentInstance subcomponentInstance) {
        SubcomponentEndpoint endpoint = StaticstructureFactory.eINSTANCE.createSubcomponentEndpoint();
        endpoint.setSubcomponent(subcomponentInstance);
        newConnector.getEndpoints().add((Object)endpoint);
        return endpoint;
    }

    private static SubcomponentEndpoint addSubcomponentEndpoint(Connector newConnector, CompositeStructure parentComponent, ComponentType componentTypeOfPort) {
        SubcomponentEndpoint endpoint = StaticstructureFactory.eINSTANCE.createSubcomponentEndpoint();
        endpoint.setSubcomponent(AssemblyConnectorBuilder.findComponentInstance(parentComponent, componentTypeOfPort));
        newConnector.getEndpoints().add((Object)endpoint);
        return endpoint;
    }

    public static SubcomponentInstance findComponentInstance(CompositeStructure parentComponent, ComponentType componentTypeOfPort) {
        SubcomponentInstance resultSubcomponentInstance = null;
        boolean found = false;
        for (SubcomponentInstance subcomponentInstance : parentComponent.getSubcomponents()) {
            if (!subcomponentInstance.getRealizedBy().equals(componentTypeOfPort)) continue;
            if (found) {
                throw new IllegalArgumentException("Assumption on input model does not hold. Only one instance per component type per composite component assumed!");
            }
            resultSubcomponentInstance = subcomponentInstance;
            found = true;
        }
        if (!found) {
            logger.warn((Object)("No subcomponent instance found for parent " + parentComponent.getName() + " and child component " + componentTypeOfPort.getName()));
        }
        return resultSubcomponentInstance;
    }
}

