/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.common.jobs;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class LoadResultsModelJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger logger = Logger.getLogger(LoadResultsModelJob.class);
    private static final String JOB_NAME = "Load Results Models into Blackboard Partions";
    private MDSDBlackboard blackboard;
    private IQAlternative alternative;

    public LoadResultsModelJob(IQAlternative alternative) {
        this.alternative = alternative;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ResourceSetPartition partition = (ResourceSetPartition)this.blackboard.getPartition("eu.qimpress.results.partition");
        logger.info((Object)"Loading Results Model Files");
        IQModel model = null;
        try {
            model = this.alternative.getRepository().getResultModel();
        }
        catch (RepositoryException e) {
            logger.error((Object)"Failed to load Result Model file.", (Throwable)e);
            return;
        }
        URI location = LoadResultsModelJob.getURIForQIElement((IQElement)model);
        logger.debug((Object)("Loading Result model file " + location));
        partition.loadModel(location);
        partition.resolveAllProxies();
    }

    public String getName() {
        return JOB_NAME;
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public static URI getURIForQIElement(IQElement elem) {
        URI location = URI.createURI((String)elem.getCorrespondingResource().getLocationURI().toString());
        return location;
    }
}

