/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.qosannotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DistType implements Enumerator
{
    NORM(0, "Norm", "Norm"),
    EXP(1, "Exp", "Exp");

    public static final int NORM_VALUE = 0;
    public static final int EXP_VALUE = 1;
    private static final DistType[] VALUES_ARRAY;
    public static final List<DistType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DistType[]{NORM, EXP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DistType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DistType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DistType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DistType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DistType get(int value) {
        switch (value) {
            case 0: {
                return NORM;
            }
            case 1: {
                return EXP;
            }
        }
        return null;
    }

    private DistType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

