/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.qosannotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AnnotationType implements Enumerator
{
    REQUIREMENT(0, "Requirement", "Requirement"),
    ESTIMATED(1, "Estimated", "Estimated"),
    MEASURED(2, "Measured", "Measured");

    public static final int REQUIREMENT_VALUE = 0;
    public static final int ESTIMATED_VALUE = 1;
    public static final int MEASURED_VALUE = 2;
    private static final AnnotationType[] VALUES_ARRAY;
    public static final List<AnnotationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AnnotationType[]{REQUIREMENT, ESTIMATED, MEASURED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AnnotationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AnnotationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AnnotationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AnnotationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AnnotationType get(int value) {
        switch (value) {
            case 0: {
                return REQUIREMENT;
            }
            case 1: {
                return ESTIMATED;
            }
            case 2: {
                return MEASURED;
            }
        }
        return null;
    }

    private AnnotationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

