/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.deployment.hardware.impl;

import eu.qimpress.samm.deployment.hardware.Cache;
import eu.qimpress.samm.deployment.hardware.CacheKind;
import eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository;
import eu.qimpress.samm.deployment.hardware.HardwareFactory;
import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.MemoryDescriptor;
import eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor;
import eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor;
import eu.qimpress.samm.deployment.hardware.ProcessorCore;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;
import eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor;
import eu.qimpress.samm.deployment.hardware.TLB;
import eu.qimpress.samm.deployment.hardware.impl.CacheImpl;
import eu.qimpress.samm.deployment.hardware.impl.HardwareDescriptorRepositoryImpl;
import eu.qimpress.samm.deployment.hardware.impl.MemoryDescriptorImpl;
import eu.qimpress.samm.deployment.hardware.impl.NetworkElementDescriptorImpl;
import eu.qimpress.samm.deployment.hardware.impl.NetworkInterfaceDescriptorImpl;
import eu.qimpress.samm.deployment.hardware.impl.ProcessorCoreImpl;
import eu.qimpress.samm.deployment.hardware.impl.ProcessorDescriptorImpl;
import eu.qimpress.samm.deployment.hardware.impl.StorageDeviceDescriptorImpl;
import eu.qimpress.samm.deployment.hardware.impl.TLBImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class HardwareFactoryImpl
extends EFactoryImpl
implements HardwareFactory {
    public static HardwareFactory init() {
        try {
            HardwareFactory theHardwareFactory = (HardwareFactory)EPackage.Registry.INSTANCE.getEFactory("http://q-impress.eu/samm/deployment/hardware");
            if (theHardwareFactory != null) {
                return theHardwareFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new HardwareFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createNetworkElementDescriptor();
            }
            case 2: {
                return this.createTLB();
            }
            case 3: {
                return this.createProcessorCore();
            }
            case 4: {
                return this.createCache();
            }
            case 5: {
                return this.createProcessorDescriptor();
            }
            case 6: {
                return this.createStorageDeviceDescriptor();
            }
            case 7: {
                return this.createMemoryDescriptor();
            }
            case 8: {
                return this.createHardwareDescriptorRepository();
            }
            case 9: {
                return this.createNetworkInterfaceDescriptor();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.createCacheKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.convertCacheKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public NetworkElementDescriptor createNetworkElementDescriptor() {
        NetworkElementDescriptorImpl networkElementDescriptor = new NetworkElementDescriptorImpl();
        return networkElementDescriptor;
    }

    @Override
    public TLB createTLB() {
        TLBImpl tlb = new TLBImpl();
        return tlb;
    }

    @Override
    public ProcessorCore createProcessorCore() {
        ProcessorCoreImpl processorCore = new ProcessorCoreImpl();
        return processorCore;
    }

    @Override
    public Cache createCache() {
        CacheImpl cache = new CacheImpl();
        return cache;
    }

    @Override
    public ProcessorDescriptor createProcessorDescriptor() {
        ProcessorDescriptorImpl processorDescriptor = new ProcessorDescriptorImpl();
        return processorDescriptor;
    }

    @Override
    public StorageDeviceDescriptor createStorageDeviceDescriptor() {
        StorageDeviceDescriptorImpl storageDeviceDescriptor = new StorageDeviceDescriptorImpl();
        return storageDeviceDescriptor;
    }

    @Override
    public MemoryDescriptor createMemoryDescriptor() {
        MemoryDescriptorImpl memoryDescriptor = new MemoryDescriptorImpl();
        return memoryDescriptor;
    }

    @Override
    public HardwareDescriptorRepository createHardwareDescriptorRepository() {
        HardwareDescriptorRepositoryImpl hardwareDescriptorRepository = new HardwareDescriptorRepositoryImpl();
        return hardwareDescriptorRepository;
    }

    @Override
    public NetworkInterfaceDescriptor createNetworkInterfaceDescriptor() {
        NetworkInterfaceDescriptorImpl networkInterfaceDescriptor = new NetworkInterfaceDescriptorImpl();
        return networkInterfaceDescriptor;
    }

    public CacheKind createCacheKindFromString(EDataType eDataType, String initialValue) {
        CacheKind result = CacheKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertCacheKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public HardwarePackage getHardwarePackage() {
        return (HardwarePackage)this.getEPackage();
    }

    @Deprecated
    public static HardwarePackage getPackage() {
        return HardwarePackage.eINSTANCE;
    }
}

