/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.visualisation;

import ch.randelshofer.tree.TreeNode;
import de.fzi.gast.core.File;
import de.fzi.gast.types.GASTClass;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;
import eu.qimpress.samm.visualisation.RepositoryVizNode;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class RepositoryVizSammSwitch
extends StaticstructureSwitch<TreeNode> {
    private ArrayList<Object> myRep = new ArrayList();
    private HashMap<String, EObject> idToEObject = null;
    private int PCNum = 0;
    private int CCNum = 0;
    private SourceCodeDecoratorRepository sourceCodeDecorator;
    private boolean defaultNaming = false;

    public RepositoryVizSammSwitch(HashMap<String, EObject> idMap, SourceCodeDecoratorRepository sourceCodeDecorator) {
        this.sourceCodeDecorator = sourceCodeDecorator;
        this.idToEObject = idMap;
        if (idMap == null || idMap.size() == 0) {
            this.defaultNaming = true;
            System.out.println("INFO: Using fallback behavior for naming");
        }
    }

    public TreeNode caseCompositeComponent(CompositeComponent component) {
        int thisCCNum = 0;
        int thisPCNum = 0;
        int linesOfCode = 0;
        ++this.CCNum;
        RepositoryVizNode node = new RepositoryVizNode();
        node.setXmiId(component.getId());
        node.setName(component.getName());
        this.addInterfaces((ComponentType)component, node);
        this.addComponentClasses((ComponentType)component, node);
        this.myRep.remove(component);
        for (SubcomponentInstance sub : component.getSubcomponents()) {
            RepositoryVizNode temp = (RepositoryVizNode)this.doSwitch((EObject)sub.getRealizedBy());
            node.addChild(temp);
            if (temp.isPrimitive()) {
                ++thisPCNum;
            } else {
                int[] childInfo = temp.getChildInfo();
                thisCCNum += childInfo[0] + childInfo[1] + 1;
            }
            linesOfCode += node.getLinesOfCode();
        }
        node.setLinesOfCode(linesOfCode);
        node.setChildInfo(thisPCNum, thisCCNum);
        return node;
    }

    public TreeNode casePrimitiveComponent(PrimitiveComponent component) {
        ++this.PCNum;
        RepositoryVizNode node = new RepositoryVizNode();
        node.setXmiId(component.getId());
        node.setPrimitive(true);
        if (!this.defaultNaming) {
            File pcFile = (File)this.idToEObject.get(component.getId());
            if (pcFile != null) {
                String pcPath = pcFile.getPathName();
                if (pcPath != null && pcPath != "") {
                    try {
                        node.setName(pcPath.substring(pcPath.lastIndexOf("\\") + 1, pcPath.indexOf(".")));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        node.setName(component.getName());
                    }
                } else {
                    node.setName(component.getName());
                }
                node.setLinesOfCode(pcFile.getLinesOfCode());
            } else {
                node.setName(component.getName());
            }
        } else {
            node.setName(component.getName());
        }
        this.addInterfaces((ComponentType)component, node);
        this.addComponentClasses((ComponentType)component, node);
        this.myRep.remove(component);
        return node;
    }

    private void addComponentClasses(ComponentType component, RepositoryVizNode node) {
        if (this.sourceCodeDecorator == null) {
            node.addComponentClasses("component classes not available (source code decorator not loaded)");
        } else {
            for (ComponentImplementingClassesLink link : this.sourceCodeDecorator.getComponentImplementingClassesLink()) {
                if (!link.getComponent().equals(component)) continue;
                for (GASTClass gastClass : link.getImplementingClasses()) {
                    node.addComponentClasses(gastClass.getSimpleName());
                }
            }
        }
    }

    private void addInterfaces(ComponentType object, RepositoryVizNode node) {
        GASTClass interfaceClass;
        for (InterfacePort providedInterface : object.getProvided()) {
            if (this.defaultNaming) {
                node.addProvidedInterface(providedInterface.getName());
                continue;
            }
            interfaceClass = (GASTClass)this.idToEObject.get(providedInterface.getInterfaceType().getId());
            if (interfaceClass == null || !interfaceClass.isAbstract()) continue;
            node.addProvidedInterface(String.valueOf(interfaceClass.getSurroundingPackage().getQualifiedName()) + "." + interfaceClass.getSimpleName());
        }
        for (InterfacePort requiredInterface : object.getRequired()) {
            if (this.defaultNaming) {
                node.addRequiredInterface(requiredInterface.getName());
                continue;
            }
            interfaceClass = (GASTClass)this.idToEObject.get(requiredInterface.getInterfaceType().getId());
            if (interfaceClass == null || !interfaceClass.isAbstract()) continue;
            node.addRequiredInterface(String.valueOf(interfaceClass.getSurroundingPackage().getQualifiedName()) + "." + interfaceClass.getSimpleName());
        }
    }

    public TreeNode caseRepository(Repository object) {
        int depth = 0;
        int thisDepth = 0;
        CompositeComponent root = null;
        RepositoryVizNode rootNode = new RepositoryVizNode();
        rootNode.setName(object.eResource().getURI().lastSegment());
        rootNode.setRoot(true);
        this.setupRepository(object);
        while (!this.myRep.isEmpty()) {
            depth = 0;
            thisDepth = 0;
            root = null;
            for (Object comp : this.myRep) {
                if (!(comp instanceof CompositeComponent) || depth >= (thisDepth = this.getDepth((CompositeComponent)comp))) continue;
                root = (CompositeComponent)comp;
                depth = thisDepth;
            }
            if (root == null) {
                this.myRep.trimToSize();
                Object[] tempRep = this.myRep.toArray();
                int i = 0;
                while (i < tempRep.length) {
                    if (tempRep[i] instanceof PrimitiveComponent) {
                        rootNode.addChild((RepositoryVizNode)this.doSwitch((EObject)((PrimitiveComponent)tempRep[i])));
                    }
                    ++i;
                }
                continue;
            }
            rootNode.addChild((RepositoryVizNode)this.doSwitch((EObject)root));
        }
        rootNode.setChildInfo(this.PCNum, this.CCNum);
        return rootNode;
    }

    public int getDepth(CompositeComponent comp) {
        int depth = 0;
        TreeIterator treeIt = comp.eAllContents();
        while (treeIt.hasNext()) {
            ComponentType temp;
            EObject subComp = (EObject)treeIt.next();
            if (!(subComp instanceof SubcomponentInstance) || !((temp = ((SubcomponentInstance)subComp).getRealizedBy()) instanceof CompositeComponent) || depth >= this.getDepth((CompositeComponent)temp) + 1) continue;
            depth = this.getDepth((CompositeComponent)temp) + 1;
        }
        if (depth == 0) {
            return 1;
        }
        return depth;
    }

    public void setupRepository(Repository comp) {
        TreeIterator treeIt = comp.eAllContents();
        while (treeIt.hasNext()) {
            EObject relevantComp = (EObject)treeIt.next();
            if (!(relevantComp instanceof PrimitiveComponent) && !(relevantComp instanceof CompositeComponent)) continue;
            this.myRep.add(relevantComp);
        }
    }
}

