/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.visualisation;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.hypertree.HyperTree;
import ch.randelshofer.tree.hypertree.SwingHTView;
import ch.randelshofer.tree.rectmap.RectmapTree;
import ch.randelshofer.tree.rectmap.RectmapView;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.visualisation.NodeSearchDialog;
import eu.qimpress.samm.visualisation.RepositoryVizEditorInput;
import eu.qimpress.samm.visualisation.RepositoryVizNode;
import eu.qimpress.samm.visualisation.RepositoryVizNodeInfo;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class RepositoryVizEditor
extends EditorPart
implements MouseListener,
KeyListener {
    public static final String ID = "org.somox.feature.repositoryVisualistation.editor";
    private RepositoryVizNode myTree;
    private RepositoryVizNode selectedNode;
    private Repository myRep;
    private String vizType = null;
    private JPanel view;
    private RepositoryVizEditorInput input;
    private Shell myShell;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.myShell = site.getShell();
        this.myTree = ((RepositoryVizEditorInput)input).getTree();
        this.myRep = ((RepositoryVizEditorInput)input).getRepository();
        this.vizType = ((RepositoryVizEditorInput)input).getActionID();
        this.input = (RepositoryVizEditorInput)input;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        HyperTree model;
        Composite swtAwtComponent = new Composite(parent, 0x1000000);
        Frame frame = SWT_AWT.new_Frame((Composite)swtAwtComponent);
        RepositoryVizNodeInfo myInfo = new RepositoryVizNodeInfo();
        if (this.vizType.equals("hyper")) {
            model = new HyperTree((TreeNode)this.myTree, (NodeInfo)myInfo);
            this.view = model.getView();
            ((SwingHTView)this.view).setToolTipEnabled(true);
            this.view.addMouseListener(this);
            this.view.setFocusable(true);
            this.view.addKeyListener(this);
            frame.add(this.view);
        }
        if (this.vizType.equals("rect")) {
            model = new RectmapTree((TreeNode)this.myTree, (NodeInfo)myInfo, new ProgressObserver(){

                public void setWarning(String arg0) {
                }

                public void setProgress(int arg0) {
                }

                public void setNote(String arg0) {
                }

                public void setModel(BoundedRangeModel arg0) {
                }

                public void setMinimum(int arg0) {
                }

                public void setMaximum(int arg0) {
                }

                public void setIndeterminate(boolean arg0) {
                }

                public void setError(String arg0) {
                }

                public void setDoCancel(Runnable arg0) {
                }

                public void setCancelable(boolean arg0) {
                }

                public boolean isIndeterminate() {
                    return false;
                }

                public boolean isCompleted() {
                    return false;
                }

                public boolean isClosed() {
                    return false;
                }

                public boolean isCanceled() {
                    return false;
                }

                public String getWarning() {
                    return null;
                }

                public int getProgress() {
                    return 0;
                }

                public String getNote() {
                    return null;
                }

                public BoundedRangeModel getModel() {
                    return null;
                }

                public int getMinimum() {
                    return 0;
                }

                public int getMaximum() {
                    return 0;
                }

                public String getError() {
                    return null;
                }

                public void complete() {
                }

                public void close() {
                }

                public void cancel() {
                }
            });
            this.view = new RectmapView((RectmapTree)model);
            ((RectmapView)this.view).setMaxDepth(Integer.MAX_VALUE);
            ((RectmapView)this.view).setToolTipEnabled(true);
            frame.add(this.view);
        }
    }

    public void setFocus() {
    }

    public JPanel getView() {
        return this.view;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            this.selectedNode = (RepositoryVizNode)((SwingHTView)this.view).getNodeUnderTheMouse(e);
            if (this.selectedNode != null && this.selectedNode.isRoot()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        NodeSearchDialog myDia = new NodeSearchDialog(RepositoryVizEditor.this.myShell, "Search", "Enter the name of a component", "", null, RepositoryVizEditor.this.input);
                        myDia.open();
                        if (myDia.getReturnCode() == 0) {
                            RepositoryVizEditor.this.center(myDia.getSelectedNode());
                        }
                    }
                });
            } else if (this.selectedNode != null) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RepositoryVizEditor.this.renaming();
                    }
                });
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void center(RepositoryVizNode node) {
        ((SwingHTView)this.view).translateToOrigin((TreeNode)node);
        this.view.repaint();
        System.out.println(node);
    }

    private void renaming() {
        String selectionId = this.selectedNode.getXmiId();
        PrimitiveComponent correspondingEObject = null;
        if (!this.selectedNode.isRoot()) {
            for (EObject comp : this.myRep.eContents()) {
                PrimitiveComponent pcComp;
                if (this.selectedNode.isPrimitive()) {
                    if (!(comp instanceof PrimitiveComponent) || !(pcComp = (PrimitiveComponent)comp).getId().equals(selectionId)) continue;
                    correspondingEObject = pcComp;
                    break;
                }
                if (!(comp instanceof CompositeComponent) || !(pcComp = (CompositeComponent)comp).getId().equals(selectionId)) continue;
                correspondingEObject = pcComp;
                break;
            }
        }
        if (correspondingEObject == null) {
            System.err.println("ERROR: Could not find component in resource");
            return;
        }
        InputDialog renameDialog = new InputDialog(this.myShell, "Rename", "Enter a custom name for the selected component", correspondingEObject.getName(), null);
        renameDialog.open();
        if (renameDialog.getReturnCode() == 0 && !renameDialog.getValue().equals("")) {
            String newName = renameDialog.getValue();
            correspondingEObject.setName(newName);
            try {
                this.myRep.eResource().save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.selectedNode.setName(newName);
            this.view.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        System.out.println("keyPressed");
    }

    @Override
    public void keyReleased(KeyEvent e) {
        System.out.println("keyReleased");
    }

    @Override
    public void keyTyped(KeyEvent e) {
        System.out.println("keyTyped");
    }
}

