/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.visualisation;

import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.visualisation.PerformantXMIResourceFactoryImpl;
import eu.qimpress.samm.visualisation.RepositoryVizDecoratorSwitch;
import eu.qimpress.samm.visualisation.RepositoryVizEditorInput;
import eu.qimpress.samm.visualisation.RepositoryVizNode;
import eu.qimpress.samm.visualisation.RepositoryVizSammSwitch;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class InitRepositoryVisualization
implements IObjectActionDelegate {
    private URI selectionURI = null;
    private URI workspaceUri = URI.createURI((String)EcorePlugin.getWorkspaceRoot().getLocationURI().toString());
    private Shell shell = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(final IAction action) {
        boolean defaultNaming = false;
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("gast", new PerformantXMIResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("samm_repository", new PerformantXMIResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("sourcecodedecorator", new PerformantXMIResourceFactoryImpl());
        Map uriMap = resSet.getURIConverter().getURIMap();
        URI decoratorUri = null;
        URI sammURI = this.selectionURI;
        uriMap.put(URI.createURI((String)sammURI.lastSegment()), sammURI);
        final Resource sammResource = resSet.createResource(sammURI);
        try {
            sammResource.load(null);
        }
        catch (Exception e1) {
            e1.getMessage();
            return;
        }
        if (sammResource.getContents().size() < 1) {
            System.err.println("ERROR: SAM Resource is empty");
            return;
        }
        decoratorUri = URI.createURI((String)sammURI.trimFileExtension().appendFileExtension("sourcecodedecorator").lastSegment()).resolve(sammURI);
        if (!resSet.getURIConverter().exists(decoratorUri, null)) {
            ResourceDialog decoratorChooser = new ResourceDialog(this.shell, "Choose source code decorator", 4);
            do {
                decoratorChooser.open();
            } while (decoratorChooser.getReturnCode() == 0 && (decoratorChooser.getURIs().isEmpty() || !((URI)decoratorChooser.getURIs().get(0)).fileExtension().equalsIgnoreCase("sourcecodedecorator")));
            if (decoratorChooser.getReturnCode() == 0 && !decoratorChooser.getURIs().isEmpty() && ((URI)decoratorChooser.getURIs().get(0)).fileExtension().equalsIgnoreCase("sourcecodedecorator")) {
                decoratorUri = (URI)decoratorChooser.getURIs().get(0);
            } else {
                defaultNaming = true;
            }
        }
        if (!defaultNaming) {
            final Resource decoratorResource = resSet.createResource(decoratorUri);
            try {
                decoratorResource.load(null);
            }
            catch (Exception e1) {
                e1.getMessage();
                defaultNaming = true;
            }
            Map proxyReferences = EcoreUtil.ProxyCrossReferencer.find((Resource)decoratorResource);
            for (Map.Entry proxy : proxyReferences.entrySet()) {
                URI proxyUri = EcoreUtil.getURI((EObject)((EObject)proxy.getKey())).trimFragment();
                if (resSet.getURIConverter().exists(proxyUri, null)) continue;
                defaultNaming = true;
                System.err.println("ERROR: Could not resolve " + proxyUri);
                break;
            }
            if (!defaultNaming) {
                Job job = new Job("GAST based naming"){

                    protected IStatus run(IProgressMonitor monitor) {
                        Repository sammRepository = (Repository)sammResource.getContents().get(0);
                        SourceCodeDecoratorRepository decoratorRepository = (SourceCodeDecoratorRepository)decoratorResource.getContents().get(0);
                        RepositoryVizDecoratorSwitch decoratorSwitch = new RepositoryVizDecoratorSwitch();
                        HashMap idToEObject = (HashMap)decoratorSwitch.doSwitch((EObject)decoratorRepository);
                        RepositoryVizSammSwitch mySwitch = new RepositoryVizSammSwitch(idToEObject, decoratorRepository);
                        RepositoryVizNode myTree = (RepositoryVizNode)mySwitch.doSwitch((EObject)sammRepository);
                        final RepositoryVizEditorInput myEditorInput = new RepositoryVizEditorInput(myTree, action.getActionDefinitionId(), sammRepository);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                    IWorkbenchPage page = window.getActivePage();
                                    page.openEditor((IEditorInput)myEditorInput, "org.somox.feature.repositoryVisualistation.editor");
                                }
                                catch (PartInitException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
        if (defaultNaming) {
            Job defaultViz = new Job("Default naming based on SAMM repository"){

                protected IStatus run(IProgressMonitor monitor) {
                    Repository sammRepository = (Repository)sammResource.getContents().get(0);
                    RepositoryVizSammSwitch mySwitch = new RepositoryVizSammSwitch(null, null);
                    RepositoryVizNode myTree = (RepositoryVizNode)mySwitch.doSwitch((EObject)sammRepository);
                    final RepositoryVizEditorInput myEditorInput = new RepositoryVizEditorInput(myTree, action.getActionDefinitionId(), sammRepository);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                IWorkbenchPage page = window.getActivePage();
                                page.openEditor((IEditorInput)myEditorInput, "org.somox.feature.repositoryVisualistation.editor");
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            defaultViz.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object mySelection = ((StructuredSelection)selection).getFirstElement();
            if (mySelection instanceof IQModel) {
                this.selectionURI = URI.createPlatformResourceURI((String)((IQModel)mySelection).getCorrespondingResource().getFullPath().toString(), (boolean)true);
            }
            if (mySelection instanceof IFile) {
                this.selectionURI = URI.createPlatformResourceURI((String)((IFile)mySelection).getFullPath().toString(), (boolean)true);
            }
        }
    }
}

