/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.utils;

import de.fzi.gast.core.Package;
import de.fzi.gast.core.Root;
import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;
import org.ow2.dsrg.fm.qabstractor.utils.ClassComparator;

public class ClassFinder {
    public static GASTClass getClassByQualifiedName(Root root, String name) {
        boolean next = true;
        String pack = name;
        Vector<String> classHierarchy = new Vector<String>();
        while (next) {
            classHierarchy.add(0, pack.substring(pack.lastIndexOf(".") + 1));
            int lastindex = pack.lastIndexOf(".");
            if (lastindex == -1) {
                pack = "";
                next = false;
            } else {
                pack = pack.substring(0, lastindex);
            }
            Package p = root.getPackageByQualifiedName(pack);
            if (p == null) continue;
            for (GASTClass c : p.getClasses()) {
                String topClass = (String)classHierarchy.firstElement();
                if (!topClass.equals(c.getSimpleName())) continue;
                classHierarchy.remove(0);
                GASTClass ret = c;
                while (!classHierarchy.isEmpty()) {
                    topClass = (String)classHierarchy.firstElement();
                    boolean finded = false;
                    for (GASTClass inner : ret.getInnerClasses()) {
                        if (!inner.getSimpleName().equals(topClass)) continue;
                        classHierarchy.remove(0);
                        ret = inner;
                        finded = true;
                        break;
                    }
                    if (finded) continue;
                    Logger.getLogger("ClassFinder").severe("Doesn't find class " + name);
                    return null;
                }
                if (!classHierarchy.isEmpty()) continue;
                return ret;
            }
        }
        return null;
    }

    public static Method findMethod(Root root, String name) {
        Method ret = null;
        String methodName = name.substring(name.lastIndexOf(".") + 1);
        String className = name.substring(0, name.lastIndexOf("."));
        GASTClass cl = ClassFinder.getClassByQualifiedName(root, className);
        if (cl != null) {
            for (Method m : cl.getMethods()) {
                if (!m.getSimpleName().equals(methodName)) continue;
                ret = m;
            }
        }
        return ret;
    }

    public static Set<GASTClass> getAllInner(GASTClass clas) {
        TreeSet<GASTClass> ret = new TreeSet<GASTClass>(new ClassComparator());
        Vector<GASTClass> toProcess = new Vector<GASTClass>();
        toProcess.add(clas);
        do {
            GASTClass processed = (GASTClass)toProcess.lastElement();
            ret.add(processed);
            toProcess.addAll((Collection<GASTClass>)processed.getInnerClasses());
            toProcess.remove(processed);
        } while (!toProcess.isEmpty());
        return ret;
    }

    public static Set<GASTClass> getAllAncestors(GASTClass clas) {
        TreeSet<GASTClass> ret = new TreeSet<GASTClass>(new ClassComparator());
        Vector<GASTClass> toProcess = new Vector<GASTClass>();
        toProcess.add(clas);
        do {
            GASTClass processed = (GASTClass)toProcess.lastElement();
            ret.add(processed);
            toProcess.addAll((Collection<GASTClass>)processed.getSuperTypes());
            toProcess.remove(processed);
        } while (!toProcess.isEmpty());
        return ret;
    }

    private ClassFinder() {
    }
}

