/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.transformation;

import de.fzi.gast.functions.Method;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.BranchStatement;
import de.fzi.gast.statements.CatchBlock;
import de.fzi.gast.statements.ExceptionHandler;
import de.fzi.gast.statements.GASTExpression;
import de.fzi.gast.statements.JumpStatement;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.types.GASTClass;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.qabstractor.utils.GastCopier;

public abstract class Transformation {
    protected Logger log;
    protected MetadataExtractor extractor;
    protected GastCopier copier = new GastCopier();

    public Transformation(Logger log, MetadataExtractor extractor) {
        this.log = log;
        this.extractor = extractor;
    }

    public void processComponent(String componentName) {
        for (GASTClass clas : this.extractor.getImplClasses(componentName)) {
            this.processClass(clas);
        }
    }

    public void processClass(GASTClass clas) {
        for (Method m : clas.getMethods()) {
            this.processMethod(m);
        }
    }

    protected void processMethod(Method method) {
        if (method.getBody() != null) {
            this.processBlock(method.getBody());
        }
    }

    protected void processBlock(BlockStatement block) {
        EList list = block.getStatements();
        Vector proces = new Vector(list);
        for (Statement s : proces) {
            this.processStatement(s);
        }
    }

    protected void processStatement(Statement statement) {
        if (statement instanceof LoopStatement) {
            this.processLoop((LoopStatement)statement);
        } else if (statement instanceof BranchStatement) {
            this.processBranch((BranchStatement)statement);
        } else if (statement instanceof BlockStatement) {
            this.processBlock((BlockStatement)statement);
        } else if (statement instanceof SimpleStatement) {
            this.processSimpleStatement((SimpleStatement)statement);
        } else if (statement instanceof JumpStatement) {
            this.processJumpStatement((JumpStatement)statement);
        } else if (statement instanceof ExceptionHandler) {
            this.processExceptionHandler((ExceptionHandler)statement);
        } else if (statement instanceof CatchBlock) {
            this.processCatchBlock((CatchBlock)statement);
        } else {
            throw new UnsupportedOperationException("unknown statement" + statement.getClass().toString());
        }
    }

    protected void processJumpStatement(JumpStatement jumpStatement) {
    }

    protected void processSimpleStatement(SimpleStatement simpleStatement) {
    }

    protected void processBranch(BranchStatement branchStatement) {
        for (Branch branch : branchStatement.getBranches()) {
            this.processStatement(branch.getStatement());
        }
    }

    protected void processLoop(LoopStatement loopStatement) {
        this.processStatement(loopStatement.getBody());
    }

    protected void removeStatement(Statement toRemove) {
        this.replaceStatement(toRemove, null);
    }

    protected void replaceStatement(Statement old, Statement neww) {
        if (neww != null) {
            this.log.debug((Object)("replace: " + old.getId() + " by " + neww.getId()));
        } else {
            this.log.debug((Object)("remove: " + old.getId()));
        }
        EObject outer = old.eContainer();
        if (outer != null) {
            if (outer instanceof BlockStatement) {
                BlockStatement bl = (BlockStatement)outer;
                int pos = bl.getStatements().indexOf((Object)old);
                bl.getStatements().remove(pos);
                if (neww != null) {
                    bl.getStatements().add(pos, (Object)neww);
                }
            } else if (outer instanceof LoopStatement) {
                LoopStatement bl = (LoopStatement)outer;
                if (neww == null) {
                    this.removeStatement((Statement)bl);
                } else {
                    bl.setBody(neww);
                }
            } else if (outer instanceof Branch) {
                Branch bl = (Branch)outer;
                bl.setStatement(neww);
            } else if (outer instanceof CatchBlock) {
                CatchBlock cb = (CatchBlock)outer;
                if (neww == null) {
                    cb.getStatements().remove((Object)old);
                } else {
                    int pos = cb.getStatements().indexOf((Object)old);
                    cb.getStatements().add(pos, (Object)neww);
                    cb.getStatements().remove((Object)old);
                }
            }
        }
    }

    protected Statement cloneStatement(Statement orig) {
        Statement ret = (Statement)this.copier.copy((EObject)orig);
        return ret;
    }

    protected GASTExpression cloneExpression(GASTExpression orig) {
        GASTExpression ret = (GASTExpression)this.copier.copy((EObject)orig);
        return ret;
    }

    protected void processCatchBlock(CatchBlock catchBlock) {
    }

    protected void processExceptionHandler(ExceptionHandler exceptionHandler) {
        this.processBlock(exceptionHandler.getGuardedBlock());
        if (exceptionHandler.getCatchBlocks() != null) {
            for (CatchBlock cb : exceptionHandler.getCatchBlocks()) {
                Vector proces = new Vector(cb.getStatements());
                for (Statement s : proces) {
                    this.processStatement(s);
                }
            }
        }
        if (exceptionHandler.getFinallyBlock() != null && exceptionHandler.getFinallyBlock().getStatements() != null && !exceptionHandler.getFinallyBlock().getStatements().isEmpty()) {
            this.processBlock(exceptionHandler.getFinallyBlock());
        }
    }
}

