/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.transformation;

import de.fzi.gast.accesses.BaseAccess;
import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.accesses.VariableAccess;
import de.fzi.gast.expressions.FunctionCall;
import de.fzi.gast.expressions.MemberAccessor;
import de.fzi.gast.functions.Method;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.BranchStatement;
import de.fzi.gast.statements.GASTExpression;
import de.fzi.gast.statements.JumpStatement;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.types.GASTClass;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.util.LinkedList;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.ow2.dsrg.fm.qabstractor.Transformer;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.tbplib.node.TBPAccept;
import org.ow2.dsrg.fm.tbplib.node.TBPAlternative;
import org.ow2.dsrg.fm.tbplib.node.TBPCondition;
import org.ow2.dsrg.fm.tbplib.node.TBPEmit;
import org.ow2.dsrg.fm.tbplib.node.TBPIf;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeNode;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeNull;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeSequence;
import org.ow2.dsrg.fm.tbplib.node.TBPMethodDeclaration;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionNode;
import org.ow2.dsrg.fm.tbplib.node.TBPRepetition;
import org.ow2.dsrg.fm.tbplib.node.TBPSpecification;
import org.ow2.dsrg.fm.tbplib.node.TBPSwitch;
import org.ow2.dsrg.fm.tbplib.node.TBPThreadContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPWhile;
import org.ow2.dsrg.fm.tbplib.reference.MethodCall;
import org.ow2.dsrg.fm.tbplib.reference.MethodSignature;

public class ToTBP {
    private MetadataExtractor extr;
    private String component;

    public TBPSpecification<String> createComponentSpecification(MetadataExtractor extr, String component, SourceCodeDecoratorRepository scdrep) {
        this.extr = extr;
        this.component = component;
        GASTClass clas = extr.getExtractedClass(component);
        LinkedList<TBPMethodDeclaration> reactions = new LinkedList<TBPMethodDeclaration>();
        LinkedList<TBPProvisionContainerNode> provisions = new LinkedList<TBPProvisionContainerNode>();
        Object prov = null;
        LinkedList<TBPThreadContainerNode> threads = new LinkedList<TBPThreadContainerNode>();
        for (Method m : clas.getMethods()) {
            TBPImperativeNull code = this.parseStatement((Statement)m.getBody());
            if (code == null) {
                code = new TBPImperativeNull();
            }
            if (m.getSimpleName().matches("Thread_.*_run")) {
                threads.add(new TBPThreadContainerNode((Object)m.getSimpleName(), (TBPImperativeNode)code, null));
                continue;
            }
            String provIface = extr.getInterfaceForProvidedMethod(component, m);
            String implProvIface = null;
            for (InterfaceSourceCodeLink link : scdrep.getInterfaceSourceCodeLink()) {
                if (!link.getInterface().getName().equals(provIface)) continue;
                implProvIface = link.getGastClass().getQualifiedName();
                break;
            }
            if (implProvIface == null) {
                return null;
            }
            reactions.add(new TBPMethodDeclaration((Object)implProvIface, (Object)m.getSimpleName(), new MethodSignature(new TreeMap(), null), (TBPImperativeNode)code, null));
            prov = prov == null ? new TBPRepetition((TBPProvisionNode)new TBPAccept(new MethodCall((Object)implProvIface, (Object)m.getSimpleName(), new LinkedList()), null)) : new TBPAlternative((TBPProvisionNode)prov, (TBPProvisionNode)new TBPRepetition((TBPProvisionNode)new TBPAccept(new MethodCall((Object)implProvIface, (Object)m.getSimpleName(), new LinkedList()), null)));
        }
        provisions.add(new TBPProvisionContainerNode(prov, Transformer.fixName(clas.getSimpleName())));
        return new TBPSpecification((Object)Transformer.fixName(clas.getQualifiedName()), new LinkedList(), provisions, reactions, threads);
    }

    private TBPImperativeNode<String> parseStatement(Statement statement) {
        if (statement instanceof LoopStatement) {
            return this.parseLoop((LoopStatement)statement);
        }
        if (statement instanceof JumpStatement) {
            return this.parseJump((JumpStatement)statement);
        }
        if (statement instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)statement;
            TBPImperativeSequence prev = null;
            for (Statement s : block.getStatements()) {
                if (prev == null) {
                    prev = this.parseStatement(s);
                    continue;
                }
                TBPImperativeNode<String> next = this.parseStatement(s);
                if (next == null) continue;
                prev = new TBPImperativeSequence(prev, next);
            }
            return prev;
        }
        if (statement instanceof SimpleStatement) {
            if (((SimpleStatement)statement).getExpression() != null) {
                return this.parseExpression(((SimpleStatement)statement).getExpression());
            }
            return this.parseFunctionaccess((EList<BaseAccess>)statement.getAccesses());
        }
        if (statement instanceof BranchStatement) {
            BranchStatement br = (BranchStatement)statement;
            TBPSwitch ret = null;
            if (br.getBranches().size() == 1) {
                Statement s = ((Branch)br.getBranches().iterator().next()).getStatement();
                TBPImperativeNode<String> tmps = this.parseStatement(s);
                assert (tmps != null) : "Previous transformation failed: Problem during creating statement";
                ret = new TBPIf(new TBPCondition(), tmps, null);
            } else {
                LinkedList<TBPImperativeNode<String>> branches = new LinkedList<TBPImperativeNode<String>>();
                for (Branch branch : br.getBranches()) {
                    Statement s = branch.getStatement();
                    TBPImperativeNode<String> tmps = this.parseStatement(s);
                    assert (tmps != null) : "Previous transformation failed: Problem during creating statement";
                    branches.add(tmps);
                }
                ret = new TBPSwitch(branches);
            }
            return ret;
        }
        if (statement == null) {
            return new TBPImperativeNull();
        }
        throw new UnsupportedOperationException("unknown statement");
    }

    private TBPImperativeNode<String> parseFunctionaccess(EList<BaseAccess> accesses) {
        Method method = null;
        String requiredIface = null;
        for (BaseAccess a : accesses) {
            if (a instanceof FunctionAccess) {
                method = (Method)((FunctionAccess)a).getTargetFunction();
                continue;
            }
            if (!(a instanceof VariableAccess)) continue;
            requiredIface = ((VariableAccess)a).getTargetVariable().getSimpleName();
        }
        if (requiredIface == null) {
            return new TBPImperativeNull();
        }
        MethodCall call = new MethodCall(requiredIface, (Object)method.getSimpleName(), new LinkedList());
        return new TBPEmit(call);
    }

    private TBPImperativeNode<String> parseLoop(LoopStatement loopStatement) {
        TBPImperativeNode<String> body = this.parseStatement(loopStatement.getBody());
        return new TBPWhile(new TBPCondition(), body);
    }

    private TBPImperativeNode<String> parseExpression(GASTExpression expression) {
        if (expression instanceof MemberAccessor) {
            MemberAccessor ma = (MemberAccessor)expression;
            return this.parseFunctionCall((FunctionCall)ma.getRight());
        }
        throw new UnsupportedOperationException("unsuported simple statement");
    }

    private TBPEmit<String> parseFunctionCall(FunctionCall functionCall) {
        String iface = this.extr.getInterfaceForRequiredMethod(this.component, (Method)functionCall.getFunction().getTargetFunction());
        String method = functionCall.getFunction().getTargetFunction().getSimpleName();
        MethodCall call = new MethodCall((Object)iface, (Object)method, new LinkedList());
        return new TBPEmit(call);
    }

    private TBPImperativeNode<String> parseJump(JumpStatement jumpStatement) {
        switch (jumpStatement.getKind()) {
            default: 
        }
        throw new UnsupportedOperationException("unsuported jump");
    }
}

