/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.transformation;

import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.LoopStatementKind;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.impl.statementsFactoryImpl;
import org.apache.log4j.Logger;
import org.ow2.dsrg.fm.qabstractor.Transformer;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.qabstractor.transformation.Transformation;

public class LoopUnifier
extends Transformation {
    public LoopUnifier(MetadataExtractor extractor) {
        super(Logger.getLogger(Transformer.class), extractor);
    }

    @Override
    protected void processLoop(LoopStatement loop) {
        super.processLoop(loop);
        statementsFactoryImpl sFactory = new statementsFactoryImpl();
        switch (loop.getKind()) {
            case WHILE: {
                return;
            }
            case FOR: {
                BlockStatement outBlock = sFactory.createBlockStatement();
                BlockStatement inBlock = sFactory.createBlockStatement();
                SimpleStatement init = sFactory.createSimpleStatement();
                init.setExpression(loop.getInitExpression());
                SimpleStatement inc = sFactory.createSimpleStatement();
                inc.setExpression(loop.getIncrementExpression());
                inBlock.getStatements().add((Object)loop.getBody());
                inBlock.getStatements().add((Object)inc);
                loop.setBody((Statement)inBlock);
                outBlock.getStatements().add((Object)init);
                outBlock.getStatements().add((Object)loop);
                this.replaceStatement((Statement)loop, (Statement)outBlock);
                break;
            }
            case DOWHILE: {
                BlockStatement outBlock = sFactory.createBlockStatement();
                BlockStatement inBlock = sFactory.createBlockStatement();
                outBlock.getStatements().add((Object)loop.getBody());
                outBlock.getStatements().add((Object)loop);
                SimpleStatement inc = sFactory.createSimpleStatement();
                inc.setExpression(loop.getIncrementExpression());
                inBlock.getStatements().add((Object)loop.getBody());
                inBlock.getStatements().add((Object)inc);
                loop.setBody((Statement)inBlock);
                this.replaceStatement((Statement)loop, (Statement)outBlock);
                break;
            }
            case FOREACH: {
                BlockStatement outBlock = sFactory.createBlockStatement();
                SimpleStatement init = sFactory.createSimpleStatement();
                init.setExpression(loop.getInitExpression());
                outBlock.getStatements().add((Object)init);
                outBlock.getStatements().add((Object)loop);
                this.replaceStatement((Statement)loop, (Statement)outBlock);
            }
        }
        loop.setKind(LoopStatementKind.WHILE);
    }
}

